/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.swing.converters;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.Converter;

public class ColorConverter
implements Converter {
    private static String usageText = "A color is encoded as a java.awt.Color name or a #xxxxxx triple of hex-bytes.";
    static /* synthetic */ Class class$java$awt$SystemColor;
    static /* synthetic */ Class class$java$awt$Color;

    public Object convert(Class type, Object value) {
        if (value != null) {
            String s = value.toString();
            if (s.length() <= 1) {
                throw new IllegalArgumentException(usageText);
            }
            if (s.charAt(0) == '#') {
                if (s.length() != 7) {
                    throw new IllegalArgumentException(usageText);
                }
                int colorValue = 0;
                try {
                    colorValue = Integer.parseInt(s.substring(1), 16);
                    return new Color(colorValue);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Can't parse \"" + s + "\" as an hexadecimal number: " + ex);
                }
            }
            try {
                Field f = (class$java$awt$SystemColor == null ? (class$java$awt$SystemColor = ColorConverter.class$("java.awt.SystemColor")) : class$java$awt$SystemColor).getField(s);
                if (!(f != null && Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && (class$java$awt$Color == null ? (class$java$awt$Color = ColorConverter.class$("java.awt.Color")) : class$java$awt$Color).isAssignableFrom(f.getType()))) {
                    throw new IllegalArgumentException(usageText);
                }
                return (Color)f.get(class$java$awt$SystemColor == null ? (class$java$awt$SystemColor = ColorConverter.class$("java.awt.SystemColor")) : class$java$awt$SystemColor);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Can't parse \"" + s + "\" as a color-name: " + ex);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

