/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.RowSetDynaClass;
import org.apache.commons.beanutils.TestResultSet;
import org.apache.commons.beanutils.TestResultSetMetaData;

public class DynaRowSetTestCase
extends TestCase {
    protected RowSetDynaClass dynaClass;
    protected String[] columns = new String[]{"bigdecimalproperty", "booleanproperty", "byteproperty", "dateproperty", "doubleproperty", "floatproperty", "intproperty", "longproperty", "nullproperty", "shortproperty", "stringproperty", "timeproperty", "timestampproperty"};

    public static Test suite() {
        return new TestSuite(DynaRowSetTestCase.class);
    }

    public DynaRowSetTestCase(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.dynaClass = new RowSetDynaClass(TestResultSet.createProxy());
    }

    public void tearDown() {
        this.dynaClass = null;
    }

    public void testGetDynaProperties() {
        DynaProperty[] dynaProps = this.dynaClass.getDynaProperties();
        DynaRowSetTestCase.assertNotNull((String)"dynaProps exists", (Object)dynaProps);
        DynaRowSetTestCase.assertEquals((String)"dynaProps length", (int)this.columns.length, (int)dynaProps.length);
        for (int i = 0; i < this.columns.length; ++i) {
            DynaRowSetTestCase.assertEquals((String)("Property " + this.columns[i]), (String)this.columns[i], (String)dynaProps[i].getName());
        }
    }

    public void testGetDynaProperty() {
        try {
            this.dynaClass.getDynaProperty(null);
            DynaRowSetTestCase.fail((String)"Did not throw IllegaArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DynaProperty dynaProp = this.dynaClass.getDynaProperty("unknownProperty");
        DynaRowSetTestCase.assertTrue((String)"unknown property returns null", (dynaProp == null ? 1 : 0) != 0);
        dynaProp = this.dynaClass.getDynaProperty("stringproperty");
        DynaRowSetTestCase.assertNotNull((String)"string property exists", (Object)dynaProp);
        DynaRowSetTestCase.assertEquals((String)"string property name", (String)"stringproperty", (String)dynaProp.getName());
        DynaRowSetTestCase.assertEquals((String)"string property class", String.class, (Object)dynaProp.getType());
    }

    public void testGetName() {
        DynaRowSetTestCase.assertEquals((String)"DynaClass name", (String)"org.apache.commons.beanutils.RowSetDynaClass", (String)this.dynaClass.getName());
    }

    public void testInconsistentOracleDriver() throws Exception {
        ResultSetMetaData metaData = TestResultSetMetaData.createProxy(new TestResultSetMetaDataInconsistent());
        ResultSet resultSet = TestResultSet.createProxy(new TestResultSetInconsistent(metaData));
        int dateColIdx = 4;
        DynaRowSetTestCase.assertEquals((String)"Date Meta Name", (String)"dateProperty", (String)metaData.getColumnName(4));
        DynaRowSetTestCase.assertEquals((String)"Date Meta Class", (String)"java.sql.Timestamp", (String)metaData.getColumnClassName(4));
        DynaRowSetTestCase.assertEquals((String)"Date Meta Type", (int)91, (int)metaData.getColumnType(4));
        DynaRowSetTestCase.assertEquals((String)"Date ResultSet Value", Date.class, resultSet.getObject("dateProperty").getClass());
        int timestampColIdx = 13;
        DynaRowSetTestCase.assertEquals((String)"Timestamp Meta Name", (String)"timestampProperty", (String)metaData.getColumnName(13));
        DynaRowSetTestCase.assertEquals((String)"Timestamp Meta Class", (String)CustomTimestamp.class.getName(), (String)metaData.getColumnClassName(13));
        DynaRowSetTestCase.assertEquals((String)"Timestamp Meta Type", (int)93, (int)metaData.getColumnType(13));
        DynaRowSetTestCase.assertEquals((String)"Timestamp ResultSet Value", CustomTimestamp.class, resultSet.getObject("timestampProperty").getClass());
        RowSetDynaClass inconsistentDynaClass = new RowSetDynaClass(resultSet);
        DynaBean firstRow = (DynaBean)inconsistentDynaClass.getRows().get(0);
        Class expectedType = null;
        DynaProperty property = null;
        property = firstRow.getDynaClass().getDynaProperty("dateproperty");
        expectedType = Date.class;
        DynaRowSetTestCase.assertEquals((String)"Date Class", expectedType, (Object)property.getType());
        DynaRowSetTestCase.assertEquals((String)"Date Value", expectedType, firstRow.get(property.getName()).getClass());
        property = firstRow.getDynaClass().getDynaProperty("timestampproperty");
        expectedType = Timestamp.class;
        DynaRowSetTestCase.assertEquals((String)"Timestamp Class", expectedType, (Object)property.getType());
        DynaRowSetTestCase.assertEquals((String)"Timestamp Value", expectedType, firstRow.get(property.getName()).getClass());
    }

    public void testLimitedRows() throws Exception {
        RowSetDynaClass limitedDynaClass = new RowSetDynaClass(TestResultSet.createProxy(), 3);
        List rows = limitedDynaClass.getRows();
        DynaRowSetTestCase.assertNotNull((String)"list exists", (Object)rows);
        DynaRowSetTestCase.assertEquals((String)"limited row count", (int)3, (int)rows.size());
    }

    public void testListCount() {
        List rows = this.dynaClass.getRows();
        DynaRowSetTestCase.assertNotNull((String)"list exists", (Object)rows);
        DynaRowSetTestCase.assertEquals((String)"list row count", (int)5, (int)rows.size());
    }

    public void testListResults() {
        List rows = this.dynaClass.getRows();
        DynaBean row = (DynaBean)rows.get(2);
        try {
            row.get("unknownProperty");
            DynaRowSetTestCase.fail((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object bigDecimalProperty = row.get("bigdecimalproperty");
        DynaRowSetTestCase.assertNotNull((String)"bigDecimalProperty exists", (Object)bigDecimalProperty);
        DynaRowSetTestCase.assertTrue((String)"bigDecimalProperty type", (boolean)(bigDecimalProperty instanceof BigDecimal));
        DynaRowSetTestCase.assertEquals((String)"bigDecimalProperty value", (double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005);
        Object intProperty = row.get("intproperty");
        DynaRowSetTestCase.assertNotNull((String)"intProperty exists", (Object)intProperty);
        DynaRowSetTestCase.assertTrue((String)"intProperty type", (boolean)(intProperty instanceof Integer));
        DynaRowSetTestCase.assertEquals((String)"intProperty value", (int)103, (int)((Integer)intProperty));
        Object nullProperty = row.get("nullproperty");
        DynaRowSetTestCase.assertNull((String)"nullProperty null", (Object)nullProperty);
        Object stringProperty = row.get("stringproperty");
        DynaRowSetTestCase.assertNotNull((String)"stringProperty exists", (Object)stringProperty);
        DynaRowSetTestCase.assertTrue((String)"stringProperty type", (boolean)(stringProperty instanceof String));
        DynaRowSetTestCase.assertEquals((String)"stringProperty value", (String)"This is a string", (String)((String)stringProperty));
    }

    public void testListResultsNormalCase() {
        RowSetDynaClass dynaClass = null;
        try {
            dynaClass = new RowSetDynaClass(TestResultSet.createProxy(), false);
        }
        catch (Exception e) {
            DynaRowSetTestCase.fail((String)("Error creating RowSetDynaClass: " + e));
        }
        List rows = dynaClass.getRows();
        DynaBean row = (DynaBean)rows.get(2);
        try {
            row.get("unknownProperty");
            DynaRowSetTestCase.fail((String)"Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Object bigDecimalProperty = row.get("bigDecimalProperty");
        DynaRowSetTestCase.assertNotNull((String)"bigDecimalProperty exists", (Object)bigDecimalProperty);
        DynaRowSetTestCase.assertTrue((String)"bigDecimalProperty type", (boolean)(bigDecimalProperty instanceof BigDecimal));
        DynaRowSetTestCase.assertEquals((String)"bigDecimalProperty value", (double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005);
        Object intProperty = row.get("intProperty");
        DynaRowSetTestCase.assertNotNull((String)"intProperty exists", (Object)intProperty);
        DynaRowSetTestCase.assertTrue((String)"intProperty type", (boolean)(intProperty instanceof Integer));
        DynaRowSetTestCase.assertEquals((String)"intProperty value", (int)103, (int)((Integer)intProperty));
        Object nullProperty = row.get("nullProperty");
        DynaRowSetTestCase.assertNull((String)"nullProperty null", (Object)nullProperty);
        Object stringProperty = row.get("stringProperty");
        DynaRowSetTestCase.assertNotNull((String)"stringProperty exists", (Object)stringProperty);
        DynaRowSetTestCase.assertTrue((String)"stringProperty type", (boolean)(stringProperty instanceof String));
        DynaRowSetTestCase.assertEquals((String)"stringProperty value", (String)"This is a string", (String)((String)stringProperty));
    }

    public void testNewInstance() {
        try {
            this.dynaClass.newInstance();
            DynaRowSetTestCase.fail((String)"Did not throw UnsupportedOperationException()");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception e) {
            DynaRowSetTestCase.fail((String)("Threw exception " + e));
        }
    }

    private static class TestResultSetMetaDataInconsistent
    extends TestResultSetMetaData {
        private TestResultSetMetaDataInconsistent() {
        }

        @Override
        public String getColumnClassName(int columnIndex) throws SQLException {
            String columnName = this.getColumnName(columnIndex);
            if (columnName.equals("dateProperty")) {
                return Timestamp.class.getName();
            }
            if (columnName.equals("timestampProperty")) {
                return CustomTimestamp.class.getName();
            }
            return super.getColumnClassName(columnIndex);
        }
    }

    private static class TestResultSetInconsistent
    extends TestResultSet {
        public TestResultSetInconsistent(ResultSetMetaData metaData) {
            super(metaData);
        }

        @Override
        public Object getObject(String columnName) throws SQLException {
            if ("timestampProperty".equals(columnName)) {
                return new CustomTimestamp();
            }
            return super.getObject(columnName);
        }
    }

    private static class CustomTimestamp {
        private final long timestamp = new java.util.Date().getTime();

        private CustomTimestamp() {
        }

        public String toString() {
            return "CustomTimestamp[" + this.timestamp + "]";
        }
    }
}

