/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.modeler.action.CreateCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.editor.CallbackType;
import org.apache.cayenne.modeler.editor.ObjCallbackMethod;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class RemoveCallbackMethodUndoableEdit
extends CayenneUndoableEdit {
    private CallbackType callbackType;
    private ObjCallbackMethod[] methods;

    public RemoveCallbackMethodUndoableEdit(CallbackType callbackType, ObjCallbackMethod[] methods) {
        this.callbackType = callbackType;
        this.methods = methods;
    }

    @Override
    public String getPresentationName() {
        return "Remove Obj Callback Methods";
    }

    @Override
    public void redo() throws CannotRedoException {
        RemoveCallbackMethodAction action = this.actionManager.getAction(RemoveCallbackMethodAction.class);
        for (ObjCallbackMethod method : this.methods) {
            action.removeCallbackMethod(this.callbackType, method.getName());
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        CreateCallbackMethodAction action = this.actionManager.getAction(CreateCallbackMethodAction.class);
        for (ObjCallbackMethod method : this.methods) {
            action.createCallbackMethod(this.callbackType, method.getName());
        }
    }
}

