/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.pref;

import java.util.prefs.Preferences;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.pref.RenamedPreferences;
import org.apache.cayenne.util.Util;

public class DataMapDefaults
extends RenamedPreferences {
    private boolean generatePairs;
    private String outputPath;
    private String subclassTemplate;
    private String superclassPackage;
    private String superclassTemplate;
    private boolean initGeneratePairs;
    public static final String GENERATE_PAIRS_PROPERTY = "generatePairs";
    public static final String OUTPUT_PATH_PROPERTY = "outputPath";
    public static final String SUBCLASS_TEMPLATE_PROPERTY = "subclassTemplate";
    public static final String SUPERCLASS_PACKAGE_PROPERTY = "superclassPackage";
    public static final String SUPERCLASS_TEMPLATE_PROPERTY = "superclassTemplate";
    public static final String DEFAULT_SUPERCLASS_PACKAGE_SUFFIX = "auto";

    public DataMapDefaults(Preferences pref) {
        super(pref);
    }

    public void updateSuperclassPackage(DataMap dataMap, boolean isClient) {
        String storedPackage = this.getSuperclassPackage();
        if (Util.isEmptyString(storedPackage) || DEFAULT_SUPERCLASS_PACKAGE_SUFFIX.equals(storedPackage)) {
            String mapPackage;
            String string = mapPackage = isClient ? dataMap.getDefaultClientPackage() : dataMap.getDefaultPackage();
            if (!Util.isEmptyString(mapPackage)) {
                String newPackage;
                if (mapPackage.endsWith(".")) {
                    mapPackage = mapPackage.substring(mapPackage.length() - 1);
                }
                if (!Util.isEmptyString(mapPackage) && !Util.nullSafeEquals(newPackage = mapPackage + "." + DEFAULT_SUPERCLASS_PACKAGE_SUFFIX, storedPackage)) {
                    this.setSuperclassPackage(newPackage);
                }
            }
        }
        if (DEFAULT_SUPERCLASS_PACKAGE_SUFFIX.equals(this.getSuperclassPackage())) {
            this.setSuperclassPackage(null);
        }
    }

    public void prePersist() {
        this.setGeneratePairs(Boolean.TRUE);
    }

    public void setSuperclassPackage(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "";
        } else if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (suffix == null) {
            suffix = "";
        } else if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        String dot = suffix.length() > 0 && prefix.length() > 0 ? "." : "";
        this.setSuperclassPackage(prefix + dot + suffix);
    }

    public boolean getGeneratePairs() {
        if (!this.initGeneratePairs) {
            this.generatePairs = this.getCurrentPreference().getBoolean(GENERATE_PAIRS_PROPERTY, false);
            this.initGeneratePairs = true;
        }
        return this.generatePairs;
    }

    public void setGeneratePairs(Boolean bool) {
        if (this.getCurrentPreference() != null) {
            this.generatePairs = bool;
            this.getCurrentPreference().putBoolean(GENERATE_PAIRS_PROPERTY, bool);
        }
    }

    public String getOutputPath() {
        if (this.outputPath == null) {
            this.outputPath = this.getCurrentPreference().get(OUTPUT_PATH_PROPERTY, null);
        }
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        if (this.getCurrentPreference() != null) {
            this.outputPath = outputPath;
            if (outputPath == null) {
                outputPath = "";
            }
            this.getCurrentPreference().put(OUTPUT_PATH_PROPERTY, outputPath);
        }
    }

    public String getSubclassTemplate() {
        if (this.subclassTemplate == null) {
            this.subclassTemplate = this.getCurrentPreference().get(SUBCLASS_TEMPLATE_PROPERTY, null);
        }
        return this.subclassTemplate;
    }

    public void setSubclassTemplate(String subclassTemplate) {
        if (this.getCurrentPreference() != null) {
            this.subclassTemplate = subclassTemplate;
            if (subclassTemplate == null) {
                subclassTemplate = "";
            }
            this.getCurrentPreference().put(SUBCLASS_TEMPLATE_PROPERTY, subclassTemplate);
        }
    }

    public String getSuperclassPackage() {
        if (this.superclassPackage == null) {
            this.superclassPackage = this.getCurrentPreference().get(SUPERCLASS_PACKAGE_PROPERTY, null);
        }
        return this.superclassPackage;
    }

    public void setSuperclassPackage(String superclassPackage) {
        if (this.getCurrentPreference() != null) {
            this.superclassPackage = superclassPackage;
            if (superclassPackage == null) {
                superclassPackage = "";
            }
            this.getCurrentPreference().put(SUPERCLASS_PACKAGE_PROPERTY, superclassPackage);
        }
    }

    public String getSuperclassTemplate() {
        if (this.superclassTemplate == null) {
            this.superclassTemplate = this.getCurrentPreference().get(SUPERCLASS_TEMPLATE_PROPERTY, null);
        }
        return this.superclassTemplate;
    }

    public void setSuperclassTemplate(String superclassTemplate) {
        if (this.getCurrentPreference() != null) {
            this.superclassTemplate = superclassTemplate;
            if (superclassTemplate == null) {
                superclassTemplate = "";
            }
            this.getCurrentPreference().put(SUPERCLASS_TEMPLATE_PROPERTY, superclassTemplate);
        }
    }

    public String getProperty(String property) {
        if (property != null && this.getCurrentPreference() != null) {
            return this.getCurrentPreference().get(property, null);
        }
        return null;
    }

    public void setProperty(String property, String value) {
        if (this.getCurrentPreference() != null) {
            if (value == null) {
                value = "";
            }
            this.getCurrentPreference().put(property, value);
        }
    }

    public void setBooleanProperty(String property, boolean value) {
        if (this.getCurrentPreference() != null) {
            this.getCurrentPreference().putBoolean(property, value);
        }
    }

    public boolean getBooleanProperty(String property) {
        if (property != null && this.getCurrentPreference() != null) {
            return this.getCurrentPreference().getBoolean(property, false);
        }
        return false;
    }
}

