/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.ssh.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.ssh.SSHCredential;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.RequestData;
import org.apache.airavata.gfac.core.authentication.SSHPublicKeyFileAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenizedSSHAuthInfo
implements SSHPublicKeyFileAuthentication {
    protected static final Logger log = LoggerFactory.getLogger(TokenizedSSHAuthInfo.class);
    private String publicKeyFile;
    private String privateKeyFile;
    private String passPhrase = null;
    private SSHCredential gssCredentials = null;
    private CredentialReader credentialReader;
    private RequestData requestData;

    public TokenizedSSHAuthInfo(CredentialReader credentialReader, RequestData requestData) {
        this.credentialReader = credentialReader;
        this.requestData = requestData;
    }

    public TokenizedSSHAuthInfo(RequestData requestData) {
        this.requestData = requestData;
    }

    public String getPublicKeyFile(String userName, String hostName) {
        return this.publicKeyFile;
    }

    public String getPrivateKeyFile(String userName, String hostName) {
        return this.privateKeyFile;
    }

    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void bannerMessage(String message) {
    }

    public SSHCredential getCredentials() throws SecurityException {
        if (this.gssCredentials == null) {
            try {
                this.gssCredentials = this.getCredentialsFromStore();
            }
            catch (Exception e) {
                log.error("An exception occurred while retrieving credentials from the credential store. Will continue with my proxy user name and password. Provided TokenId:" + this.requestData.getTokenId() + e.getMessage(), (Throwable)e);
            }
            if (this.gssCredentials == null) {
                System.out.println("Authenticating with provided token failed, so falling back to authenticate with defaultCredentials");
                try {
                    this.gssCredentials = this.getDefaultCredentials();
                }
                catch (Exception e) {
                    throw new SecurityException("Error retrieving my proxy using username password", e.getCause());
                }
            }
            if (this.gssCredentials == null) {
                throw new SecurityException("Unable to retrieve my proxy credentials to continue operation.");
            }
        }
        return this.gssCredentials;
    }

    public SSHCredential getCredentialsFromStore() throws Exception {
        Credential credential;
        if (this.getCredentialReader() == null) {
            this.credentialReader = GFacUtils.getCredentialReader();
            if (this.credentialReader == null) {
                return null;
            }
        }
        if ((credential = this.getCredentialReader().getCredential(this.getRequestData().getGatewayId(), this.getRequestData().getTokenId())) instanceof SSHCredential) {
            SSHCredential credential1 = (SSHCredential)credential;
            this.publicKeyFile = this.writeFileToDisk(credential1.getPublicKey());
            this.privateKeyFile = this.writeFileToDisk(credential1.getPrivateKey());
            this.passPhrase = credential1.getPassphrase();
            System.out.println(this.publicKeyFile);
            System.out.println(this.privateKeyFile);
            System.out.println(this.passPhrase);
            this.getRequestData().setRequestUser(credential1.getPortalUserName());
            return credential1;
        }
        log.info("Could not find SSH credentials for token - " + this.getRequestData().getTokenId() + " and gateway id - " + this.getRequestData().getGatewayId());
        return null;
    }

    public SSHCredential getDefaultCredentials() throws GFacException, ApplicationSettingsException, IOException {
        Properties configurationProperties = ServerSettings.getProperties();
        String sshUserName = configurationProperties.getProperty("ssh.username");
        this.getRequestData().setRequestUser(sshUserName);
        this.privateKeyFile = configurationProperties.getProperty("private.ssh.key");
        this.publicKeyFile = configurationProperties.getProperty("public.ssh.key");
        this.passPhrase = configurationProperties.getProperty("ssh.keypass");
        this.getRequestData().setRequestUser(sshUserName);
        return new SSHCredential(IOUtil.readToByteArray((File)new File(this.privateKeyFile)), IOUtil.readToByteArray((File)new File(this.publicKeyFile)), this.passPhrase, this.requestData.getGatewayId(), sshUserName);
    }

    public CredentialReader getCredentialReader() {
        return this.credentialReader;
    }

    public RequestData getRequestData() {
        return this.requestData;
    }

    private String writeFileToDisk(byte[] data) {
        File temp = null;
        try {
            temp = File.createTempFile("id_rsa", "");
            FileOutputStream bw = new FileOutputStream(temp);
            bw.write(data);
            bw.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return temp.getAbsolutePath();
    }
}

