/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import java.util.Arrays;
import java.util.Map;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.Task;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.TaskTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentSetupTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentSetupTask.class);

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus status = new TaskStatus(TaskState.COMPLETED);
        try {
            RemoteCluster remoteCluster = taskContext.getParentProcessContext().getJobSubmissionRemoteCluster();
            remoteCluster.makeDirectory(taskContext.getParentProcessContext().getWorkingDir());
            status.setReason("Successfully created environment");
        }
        catch (GFacException e) {
            String msg = "Error while environment setup";
            log.error(msg, (Throwable)e);
            status.setState(TaskState.FAILED);
            status.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        return status;
    }

    public TaskStatus recover(TaskContext taskContext) {
        return this.execute(taskContext);
    }

    public TaskTypes getType() {
        return TaskTypes.ENV_SETUP;
    }
}

