/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.cloud.aurora.client.sdk.Resource;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ResourceAggregate
implements TBase<ResourceAggregate, _Fields>,
Serializable,
Cloneable,
Comparable<ResourceAggregate> {
    private static final TStruct STRUCT_DESC = new TStruct("ResourceAggregate");
    private static final TField NUM_CPUS_FIELD_DESC = new TField("numCpus", 4, 1);
    private static final TField RAM_MB_FIELD_DESC = new TField("ramMb", 10, 2);
    private static final TField DISK_MB_FIELD_DESC = new TField("diskMb", 10, 3);
    private static final TField RESOURCES_FIELD_DESC = new TField("resources", 14, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public double numCpus;
    public long ramMb;
    public long diskMb;
    public Set<Resource> resources;
    private static final int __NUMCPUS_ISSET_ID = 0;
    private static final int __RAMMB_ISSET_ID = 1;
    private static final int __DISKMB_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ResourceAggregate() {
    }

    public ResourceAggregate(double numCpus, long ramMb, long diskMb, Set<Resource> resources) {
        this();
        this.numCpus = numCpus;
        this.setNumCpusIsSet(true);
        this.ramMb = ramMb;
        this.setRamMbIsSet(true);
        this.diskMb = diskMb;
        this.setDiskMbIsSet(true);
        this.resources = resources;
    }

    public ResourceAggregate(ResourceAggregate other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.numCpus = other.numCpus;
        this.ramMb = other.ramMb;
        this.diskMb = other.diskMb;
        if (other.isSetResources()) {
            HashSet<Resource> __this__resources = new HashSet<Resource>(other.resources.size());
            for (Resource other_element : other.resources) {
                __this__resources.add(new Resource(other_element));
            }
            this.resources = __this__resources;
        }
    }

    public ResourceAggregate deepCopy() {
        return new ResourceAggregate(this);
    }

    public void clear() {
        this.setNumCpusIsSet(false);
        this.numCpus = 0.0;
        this.setRamMbIsSet(false);
        this.ramMb = 0L;
        this.setDiskMbIsSet(false);
        this.diskMb = 0L;
        this.resources = null;
    }

    public double getNumCpus() {
        return this.numCpus;
    }

    public ResourceAggregate setNumCpus(double numCpus) {
        this.numCpus = numCpus;
        this.setNumCpusIsSet(true);
        return this;
    }

    public void unsetNumCpus() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetNumCpus() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setNumCpusIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getRamMb() {
        return this.ramMb;
    }

    public ResourceAggregate setRamMb(long ramMb) {
        this.ramMb = ramMb;
        this.setRamMbIsSet(true);
        return this;
    }

    public void unsetRamMb() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetRamMb() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setRamMbIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getDiskMb() {
        return this.diskMb;
    }

    public ResourceAggregate setDiskMb(long diskMb) {
        this.diskMb = diskMb;
        this.setDiskMbIsSet(true);
        return this;
    }

    public void unsetDiskMb() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetDiskMb() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setDiskMbIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getResourcesSize() {
        return this.resources == null ? 0 : this.resources.size();
    }

    public Iterator<Resource> getResourcesIterator() {
        return this.resources == null ? null : this.resources.iterator();
    }

    public void addToResources(Resource elem) {
        if (this.resources == null) {
            this.resources = new HashSet<Resource>();
        }
        this.resources.add(elem);
    }

    public Set<Resource> getResources() {
        return this.resources;
    }

    public ResourceAggregate setResources(Set<Resource> resources) {
        this.resources = resources;
        return this;
    }

    public void unsetResources() {
        this.resources = null;
    }

    public boolean isSetResources() {
        return this.resources != null;
    }

    public void setResourcesIsSet(boolean value) {
        if (!value) {
            this.resources = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case NUM_CPUS: {
                if (value == null) {
                    this.unsetNumCpus();
                    break;
                }
                this.setNumCpus((Double)value);
                break;
            }
            case RAM_MB: {
                if (value == null) {
                    this.unsetRamMb();
                    break;
                }
                this.setRamMb((Long)value);
                break;
            }
            case DISK_MB: {
                if (value == null) {
                    this.unsetDiskMb();
                    break;
                }
                this.setDiskMb((Long)value);
                break;
            }
            case RESOURCES: {
                if (value == null) {
                    this.unsetResources();
                    break;
                }
                this.setResources((Set)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NUM_CPUS: {
                return this.getNumCpus();
            }
            case RAM_MB: {
                return this.getRamMb();
            }
            case DISK_MB: {
                return this.getDiskMb();
            }
            case RESOURCES: {
                return this.getResources();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NUM_CPUS: {
                return this.isSetNumCpus();
            }
            case RAM_MB: {
                return this.isSetRamMb();
            }
            case DISK_MB: {
                return this.isSetDiskMb();
            }
            case RESOURCES: {
                return this.isSetResources();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ResourceAggregate) {
            return this.equals((ResourceAggregate)that);
        }
        return false;
    }

    public boolean equals(ResourceAggregate that) {
        if (that == null) {
            return false;
        }
        boolean this_present_numCpus = true;
        boolean that_present_numCpus = true;
        if (this_present_numCpus || that_present_numCpus) {
            if (!this_present_numCpus || !that_present_numCpus) {
                return false;
            }
            if (this.numCpus != that.numCpus) {
                return false;
            }
        }
        boolean this_present_ramMb = true;
        boolean that_present_ramMb = true;
        if (this_present_ramMb || that_present_ramMb) {
            if (!this_present_ramMb || !that_present_ramMb) {
                return false;
            }
            if (this.ramMb != that.ramMb) {
                return false;
            }
        }
        boolean this_present_diskMb = true;
        boolean that_present_diskMb = true;
        if (this_present_diskMb || that_present_diskMb) {
            if (!this_present_diskMb || !that_present_diskMb) {
                return false;
            }
            if (this.diskMb != that.diskMb) {
                return false;
            }
        }
        boolean this_present_resources = this.isSetResources();
        boolean that_present_resources = that.isSetResources();
        if (this_present_resources || that_present_resources) {
            if (!this_present_resources || !that_present_resources) {
                return false;
            }
            if (!this.resources.equals(that.resources)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_numCpus = true;
        list.add(present_numCpus);
        if (present_numCpus) {
            list.add(this.numCpus);
        }
        boolean present_ramMb = true;
        list.add(present_ramMb);
        if (present_ramMb) {
            list.add(this.ramMb);
        }
        boolean present_diskMb = true;
        list.add(present_diskMb);
        if (present_diskMb) {
            list.add(this.diskMb);
        }
        boolean present_resources = this.isSetResources();
        list.add(present_resources);
        if (present_resources) {
            list.add(this.resources);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ResourceAggregate other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetNumCpus()).compareTo(other.isSetNumCpus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumCpus() && (lastComparison = TBaseHelper.compareTo((double)this.numCpus, (double)other.numCpus)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRamMb()).compareTo(other.isSetRamMb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRamMb() && (lastComparison = TBaseHelper.compareTo((long)this.ramMb, (long)other.ramMb)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDiskMb()).compareTo(other.isSetDiskMb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDiskMb() && (lastComparison = TBaseHelper.compareTo((long)this.diskMb, (long)other.diskMb)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetResources()).compareTo(other.isSetResources());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetResources() && (lastComparison = TBaseHelper.compareTo(this.resources, other.resources)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResourceAggregate(");
        boolean first = true;
        sb.append("numCpus:");
        sb.append(this.numCpus);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ramMb:");
        sb.append(this.ramMb);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("diskMb:");
        sb.append(this.diskMb);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("resources:");
        if (this.resources == null) {
            sb.append("null");
        } else {
            sb.append(this.resources);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ResourceAggregateStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ResourceAggregateTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NUM_CPUS, new FieldMetaData("numCpus", 3, new FieldValueMetaData(4)));
        tmpMap.put(_Fields.RAM_MB, new FieldMetaData("ramMb", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DISK_MB, new FieldMetaData("diskMb", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.RESOURCES, new FieldMetaData("resources", 3, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, Resource.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ResourceAggregate.class, metaDataMap);
    }

    private static class ResourceAggregateTupleScheme
    extends TupleScheme<ResourceAggregate> {
        private ResourceAggregateTupleScheme() {
        }

        public void write(TProtocol prot, ResourceAggregate struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetNumCpus()) {
                optionals.set(0);
            }
            if (struct.isSetRamMb()) {
                optionals.set(1);
            }
            if (struct.isSetDiskMb()) {
                optionals.set(2);
            }
            if (struct.isSetResources()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetNumCpus()) {
                oprot.writeDouble(struct.numCpus);
            }
            if (struct.isSetRamMb()) {
                oprot.writeI64(struct.ramMb);
            }
            if (struct.isSetDiskMb()) {
                oprot.writeI64(struct.diskMb);
            }
            if (struct.isSetResources()) {
                oprot.writeI32(struct.resources.size());
                for (Resource _iter88 : struct.resources) {
                    _iter88.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, ResourceAggregate struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.numCpus = iprot.readDouble();
                struct.setNumCpusIsSet(true);
            }
            if (incoming.get(1)) {
                struct.ramMb = iprot.readI64();
                struct.setRamMbIsSet(true);
            }
            if (incoming.get(2)) {
                struct.diskMb = iprot.readI64();
                struct.setDiskMbIsSet(true);
            }
            if (incoming.get(3)) {
                TSet _set89 = new TSet(12, iprot.readI32());
                struct.resources = new HashSet<Resource>(2 * _set89.size);
                for (int _i91 = 0; _i91 < _set89.size; ++_i91) {
                    Resource _elem90 = new Resource();
                    _elem90.read((TProtocol)iprot);
                    struct.resources.add(_elem90);
                }
                struct.setResourcesIsSet(true);
            }
        }
    }

    private static class ResourceAggregateTupleSchemeFactory
    implements SchemeFactory {
        private ResourceAggregateTupleSchemeFactory() {
        }

        public ResourceAggregateTupleScheme getScheme() {
            return new ResourceAggregateTupleScheme();
        }
    }

    private static class ResourceAggregateStandardScheme
    extends StandardScheme<ResourceAggregate> {
        private ResourceAggregateStandardScheme() {
        }

        public void read(TProtocol iprot, ResourceAggregate struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 4) {
                            struct.numCpus = iprot.readDouble();
                            struct.setNumCpusIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.ramMb = iprot.readI64();
                            struct.setRamMbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.diskMb = iprot.readI64();
                            struct.setDiskMbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 14) {
                            TSet _set84 = iprot.readSetBegin();
                            struct.resources = new HashSet<Resource>(2 * _set84.size);
                            for (int _i86 = 0; _i86 < _set84.size; ++_i86) {
                                Resource _elem85 = new Resource();
                                _elem85.read(iprot);
                                struct.resources.add(_elem85);
                            }
                            iprot.readSetEnd();
                            struct.setResourcesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, ResourceAggregate struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(NUM_CPUS_FIELD_DESC);
            oprot.writeDouble(struct.numCpus);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(RAM_MB_FIELD_DESC);
            oprot.writeI64(struct.ramMb);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(DISK_MB_FIELD_DESC);
            oprot.writeI64(struct.diskMb);
            oprot.writeFieldEnd();
            if (struct.resources != null) {
                oprot.writeFieldBegin(RESOURCES_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.resources.size()));
                for (Resource _iter87 : struct.resources) {
                    _iter87.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ResourceAggregateStandardSchemeFactory
    implements SchemeFactory {
        private ResourceAggregateStandardSchemeFactory() {
        }

        public ResourceAggregateStandardScheme getScheme() {
            return new ResourceAggregateStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NUM_CPUS(1, "numCpus"),
        RAM_MB(2, "ramMb"),
        DISK_MB(3, "diskMb"),
        RESOURCES(4, "resources");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NUM_CPUS;
                }
                case 2: {
                    return RAM_MB;
                }
                case 3: {
                    return DISK_MB;
                }
                case 4: {
                    return RESOURCES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

