/*
 * Decompiled with CFR 0.152.
 */
package org.compass.spring.device.ojb;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.compass.gps.device.ojb.OjbGpsDeviceUtils;
import org.compass.spring.device.ojb.SpringOjbGpsDevice;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ojb.OjbFactoryUtils;
import org.springframework.orm.ojb.PersistenceBrokerTemplate;

public class SpringOjbGpsDeviceInterceptor
implements MethodInterceptor,
InitializingBean {
    private SpringOjbGpsDevice ojbGpsDevice;

    public void afterPropertiesSet() throws Exception {
        if (this.ojbGpsDevice == null) {
            throw new IllegalArgumentException("Must set the ojbGpsDevice property");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        PersistenceBroker pb = OjbFactoryUtils.getPersistenceBroker((PBKey)this.getPersistenceBrokerTemplate().getPbKey(), (boolean)this.getPersistenceBrokerTemplate().isAllowCreate());
        OjbGpsDeviceUtils.attachPersistenceBrokerForMirror(this.ojbGpsDevice, pb);
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            OjbGpsDeviceUtils.removePersistenceBrokerForMirror(this.ojbGpsDevice, pb);
        }
    }

    private PersistenceBrokerTemplate getPersistenceBrokerTemplate() {
        return this.ojbGpsDevice.getPersistenceBrokerTemplate();
    }

    public SpringOjbGpsDevice getOjbGpsDevice() {
        return this.ojbGpsDevice;
    }

    public void setOjbGpsDevice(SpringOjbGpsDevice ojbGpsDevice) {
        this.ojbGpsDevice = ojbGpsDevice;
    }
}

