/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding.scanner;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.compass.core.config.binding.scanner.Filter;
import org.compass.core.config.binding.scanner.InputStreamWrapper;
import org.compass.core.config.binding.scanner.ScanItem;
import org.compass.core.config.binding.scanner.Scanner;

public class JarScanner
implements Scanner {
    private JarInputStream jar;
    private JarEntry next;
    private Filter filter;
    private boolean initial = true;
    private boolean closed = false;

    public JarScanner(String basePackage, InputStream is, Filter filter) throws IOException {
        this.filter = new JarPackageFilterWrapper(basePackage, filter);
        this.jar = new JarInputStream(is);
    }

    private void setNext() {
        this.initial = true;
        try {
            if (this.next != null) {
                this.jar.closeEntry();
            }
            this.next = null;
            do {
                this.next = this.jar.getNextJarEntry();
            } while (this.next != null && (this.next.isDirectory() || this.filter == null || !this.filter.accepts(this.next.getName())));
            if (this.next == null) {
                this.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed to browse jar", e);
        }
    }

    public ScanItem next() {
        if (this.closed || this.next == null && !this.initial) {
            return null;
        }
        this.setNext();
        if (this.next == null) {
            return null;
        }
        return new ScanItem(new InputStreamWrapper(this.jar), this.next.getName());
    }

    public void close() {
        try {
            this.closed = true;
            this.jar.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class JarPackageFilterWrapper
    implements Filter {
        private String basePackage;
        private Filter delegate;

        private JarPackageFilterWrapper(String basePackage, Filter delegate) {
            this.basePackage = basePackage;
            this.delegate = delegate;
        }

        public boolean accepts(String name) {
            if (!name.startsWith(this.basePackage)) {
                return false;
            }
            return this.delegate.accepts(name.substring(this.basePackage.length() + 1));
        }
    }
}

