/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.MarkAction;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MarkOnceAction
extends MarkAction {
    public MarkOnceAction(ITypeExpression type, INumberExpression scoreValue, List<INumberExpression> list) {
        super(type, scoreValue, list);
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<Integer> indexList = this.getIndexList(context, this.list, stream);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(indexList, element.getContainer());
        Type targetType = this.type.getType(context, stream);
        if (targetType == null) {
            return;
        }
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            boolean partof = false;
            List<RutaBasic> basicsInWindow = stream.getBasicsInWindow(matchedAnnotation);
            for (RutaBasic rutaBasic : basicsInWindow) {
                if (!rutaBasic.isPartOf(targetType)) continue;
                partof = true;
                break;
            }
            if (partof) continue;
            this.createAnnotation(matchedAnnotation, context, stream);
        }
    }
}

