/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.dialog;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapResourcesBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.ModalCloseButton;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.util.Strings2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class Modal<T>
extends GenericPanel<T> {
    private static final long serialVersionUID = 1L;
    public static final String BUTTON_MARKUP_ID = "button";
    private boolean show = false;
    private boolean fadein = true;
    private boolean keyboard = true;
    private boolean closeOnEscapeKey = true;
    private Backdrop backdrop = Backdrop.TRUE;
    private final IModel<Boolean> disableEnforceFocus = Model.of((Serializable)Boolean.valueOf(false));
    private Component headerLabel;
    private final List<Component> buttons = new ArrayList<Component>();
    private MarkupContainer footer;
    private MarkupContainer header;
    private AjaxEventBehavior closeBehavior;
    private Size size = Size.Default;
    private Fullscreen fullscreen = Fullscreen.None;

    public Modal(String markupId) {
        this(markupId, null);
    }

    public Modal(String id, IModel<T> model) {
        super(id, model);
        this.setOutputMarkupPlaceholderTag(true);
        this.footer = this.createFooter("footer");
        this.header = this.createHeader("header");
    }

    private Component getHeaderLabel() {
        if (this.headerLabel == null) {
            this.headerLabel = this.createHeaderLabel("header-label", "");
        }
        return this.headerLabel;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.header.add(new Component[]{this.getHeaderLabel()});
        this.headerLabel.setOutputMarkupId(true);
        Component headerCloseButton = this.createHeaderCloseButton("header-close-button");
        this.header.add(new Component[]{headerCloseButton});
        headerCloseButton.setOutputMarkupId(true);
        this.footer.add(new Component[]{new ListView<Component>("buttons", this.buttons){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
        WebMarkupContainer dialog = this.createDialog("dialog");
        this.add(new Component[]{dialog});
        dialog.add(new Component[]{this.header, this.footer});
        BootstrapResourcesBehavior.addTo((Component)this);
    }

    protected Component createHeaderCloseButton(String id) {
        return new WebMarkupContainer(id);
    }

    protected Component createHeaderLabel(String id, String label) {
        return new Label(id, (Serializable)((Object)label));
    }

    protected MarkupContainer createHeader(String id) {
        return new WebMarkupContainer(id);
    }

    protected MarkupContainer createFooter(String id) {
        return new WebMarkupContainer(id);
    }

    protected WebMarkupContainer createDialog(String id) {
        return new TransparentWebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Set<Size> sizes = Arrays.stream(Size.values()).collect(Collectors.toSet());
                sizes.remove(Size.Default);
                sizes.forEach(s -> Attributes.removeClass(tag, s));
                if (sizes.contains(Modal.this.size)) {
                    Attributes.addClass(tag, Modal.this.size);
                }
                Set<Fullscreen> fulscreens = Arrays.stream(Fullscreen.values()).collect(Collectors.toSet());
                fulscreens.remove(Fullscreen.None);
                fulscreens.forEach(s -> Attributes.removeClass(tag, s));
                if (fulscreens.contains(Modal.this.fullscreen)) {
                    Attributes.addClass(tag, Modal.this.fullscreen);
                }
            }
        };
    }

    public Modal<T> size(Size size) {
        this.size = size;
        return this;
    }

    public Modal<T> fullscreen(Fullscreen fullscreen) {
        this.fullscreen = fullscreen;
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "div");
        Attributes.addClass(tag, "modal");
        if (this.useFadein()) {
            Attributes.addClass(tag, "fade");
        } else {
            Attributes.removeClass(tag, "fade");
        }
        Attributes.set(tag, "data-bs-keyboard", "" + this.closeOnEscapeKey);
        Attributes.set(tag, "data-bs-focus", "" + ((Boolean)this.disableEnforceFocus.getObject() == false));
        if (this.backdrop != Backdrop.TRUE) {
            Attributes.set(tag, "data-bs-backdrop", this.backdrop.name().toLowerCase());
        }
        Attributes.set(tag, "role", "dialog");
        Attributes.set(tag, "aria-labelledby", this.getHeaderLabel().getMarkupId());
        Attributes.set(tag, "aria-hidden", "true");
    }

    protected void onClose(IPartialPageRequestHandler target) {
    }

    public Modal<T> header(IModel<String> label) {
        this.getHeaderLabel().setDefaultModel(label);
        this.setHeaderVisible(true);
        return this;
    }

    public Modal<T> header(IModel<String> label, boolean escapeMarkup) {
        this.getHeaderLabel().setDefaultModel(label).setEscapeModelStrings(escapeMarkup);
        return this;
    }

    public Modal<T> setFooterVisible(boolean visible) {
        this.footer.setVisible(visible);
        return this;
    }

    public Modal<T> setHeaderVisible(boolean visible) {
        this.header.setVisible(visible);
        return this;
    }

    public final Modal<T> setUseCloseHandler(boolean useCloseHandler) {
        if (useCloseHandler) {
            if (this.closeBehavior == null) {
                this.closeBehavior = new ModalCloseBehavior();
                this.add(new Behavior[]{this.closeBehavior});
            }
        } else if (this.closeBehavior != null) {
            this.remove(new Behavior[]{this.closeBehavior});
            this.closeBehavior = null;
        }
        return this;
    }

    public Modal<T> show(boolean show) {
        this.show = show;
        return this;
    }

    public Modal<T> setCloseOnEscapeKey(boolean close) {
        this.closeOnEscapeKey = close;
        return this;
    }

    public Modal<T> setBackdrop(Backdrop backdrop) {
        this.backdrop = backdrop;
        return this;
    }

    public Modal<T> appendCloseDialogJavaScript(IPartialPageRequestHandler target) {
        target.prependJavaScript((CharSequence)this.createActionScript(this.getMarkupId(true), "hide"));
        return this;
    }

    public Modal<T> close(IPartialPageRequestHandler target) {
        return this.appendCloseDialogJavaScript(target);
    }

    public Modal<T> appendShowDialogJavaScript(IPartialPageRequestHandler target) {
        target.appendJavaScript((CharSequence)this.createActionScript(this.getMarkupId(true), "show"));
        return this;
    }

    public Modal<T> show(IPartialPageRequestHandler target) {
        return this.appendShowDialogJavaScript(target);
    }

    protected String createActionScript(String markupId, String action) {
        return "bootstrap.Modal.getInstance(document.getElementById('" + Strings2.escapeMarkupId((CharSequence)markupId) + "'))." + action + "();";
    }

    public Modal<T> addOpenerAttributesTo(Component component) {
        component.add(new Behavior[]{new AttributeModifier("data-bs-toggle", (Serializable)((Object)"modal"))});
        component.add(new Behavior[]{new AttributeModifier("href", (Serializable)((Object)("#" + this.getMarkupId(true))))});
        return this;
    }

    public Modal<T> addCloseButton(IModel<String> label) {
        ModalCloseButton button = new ModalCloseButton(label);
        button.setAnchor(this);
        return this.addButton((Component)button);
    }

    public Modal<T> addCloseButton() {
        return this.addCloseButton((IModel<String>)Model.of((Serializable)((Object)"Close")));
    }

    public Modal<T> addButton(Component button) {
        if (!BUTTON_MARKUP_ID.equals(button.getId())) {
            throw new IllegalArgumentException(String.format("Invalid button markup id. Must be '%s'.", BUTTON_MARKUP_ID));
        }
        this.buttons.add(button);
        return this;
    }

    private void handleCloseEvent(IPartialPageRequestHandler target) {
        if (this.isVisible()) {
            this.onClose(target);
            this.appendCloseDialogJavaScript(target);
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        if (Strings.isEmpty((String)this.getHeaderLabel().getDefaultModelObjectAsString())) {
            this.headerLabel.setDefaultModelObject((Object)"&nbsp;");
            this.headerLabel.setEscapeModelStrings(false);
        }
        this.footer.setVisible(this.buttons.size() > 0);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createBasicInitializerScript(this.getMarkupId(true))));
    }

    protected String createBasicInitializerScript(String markupId) {
        return "new bootstrap.Modal(document.getElementById('" + markupId + "'))" + (this.showImmediately() ? ".show()" : "") + ";";
    }

    protected final boolean useFadein() {
        return this.fadein;
    }

    protected final boolean useKeyboard() {
        return this.keyboard;
    }

    protected final boolean showImmediately() {
        return this.show;
    }

    public final Modal<T> setFadeIn(boolean fadein) {
        this.fadein = fadein;
        return this;
    }

    public final Modal<T> setUseKeyboard(boolean keyboard) {
        this.keyboard = keyboard;
        return this;
    }

    public final Modal<T> setDisableEnforceFocus(boolean disable) {
        this.disableEnforceFocus.setObject((Object)disable);
        return this;
    }

    public static enum Backdrop {
        TRUE,
        FALSE,
        STATIC;

    }

    public static enum Size implements ICssClassNameProvider
    {
        Small("sm"),
        Default(""),
        Large("lg"),
        Extra_large("xl");

        private final String cssClassName;

        private Size(String cssClassName) {
            this.cssClassName = cssClassName;
        }

        @Override
        public String cssClassName() {
            return "modal-" + this.cssClassName;
        }
    }

    public static enum Fullscreen implements ICssClassNameProvider
    {
        None(""),
        Always("fullscreen"),
        Sm_down("fullscreen-sm-down"),
        Md_down("fullscreen-md-down"),
        Lg_down("fullscreen-lg-down"),
        Xl_down("fullscreen-xl-down"),
        Xxl_down("fullscreen-xxl-down");

        private final String cssClassName;

        private Fullscreen(String cssClassName) {
            this.cssClassName = cssClassName;
        }

        @Override
        public String cssClassName() {
            return "modal-" + this.cssClassName;
        }
    }

    private class ModalCloseBehavior
    extends AjaxEventBehavior {
        private static final long serialVersionUID = 1L;

        public ModalCloseBehavior() {
            super("hidden.bs.modal");
        }

        protected void onEvent(AjaxRequestTarget target) {
            Modal.this.handleCloseEvent((IPartialPageRequestHandler)target);
        }

        protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
            super.updateAjaxAttributes(attributes);
            attributes.setEventPropagation(AjaxRequestAttributes.EventPropagation.BUBBLE);
        }
    }
}

