/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class SubProcessJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SubProcessJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SubProcessJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SubProcess", SubProcessJsonConverter.class);
        convertersToBpmnMap.put("CollapsedSubProcess", SubProcessJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SubProcess.class, SubProcessJsonConverter.class);
        convertersToJsonMap.put(Transaction.class, SubProcessJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        GraphicInfo graphicInfo = this.model.getGraphicInfo(baseElement.getId());
        if (BooleanUtils.isFalse((Boolean)graphicInfo.getExpanded())) {
            return "CollapsedSubProcess";
        }
        return "SubProcess";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        SubProcess subProcess = (SubProcess)baseElement;
        propertiesNode.put("activitytype", this.getStencilId(baseElement));
        GraphicInfo gi = this.model.getGraphicInfo(baseElement.getId());
        ArrayNode subProcessShapesArrayNode = JSON_MAPPER.createArrayNode();
        GraphicInfo graphicInfo = this.model.getGraphicInfo(subProcess.getId());
        if (BooleanUtils.isFalse((Boolean)gi.getExpanded())) {
            this.processor.processFlowElements((FlowElementsContainer)subProcess, this.model, subProcessShapesArrayNode, converterContext, 0.0, 0.0);
        } else {
            this.processor.processFlowElements((FlowElementsContainer)subProcess, this.model, subProcessShapesArrayNode, converterContext, graphicInfo.getX(), graphicInfo.getY());
        }
        this.flowElementNode.set("childShapes", (JsonNode)subProcessShapesArrayNode);
        if (subProcess instanceof Transaction) {
            propertiesNode.put("istransaction", true);
        }
        BpmnJsonConverterUtil.convertDataPropertiesToJson(subProcess.getDataObjects(), propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        Object subProcess = JsonConverterUtil.getPropertyValueAsBoolean("istransaction", elementNode) ? new Transaction() : new SubProcess();
        JsonNode childShapesArray = elementNode.get("childShapes");
        this.processor.processJsonElements(childShapesArray, modelNode, (BaseElement)subProcess, shapeMap, converterContext, this.model);
        JsonNode processDataPropertiesNode = elementNode.get("properties").get("dataproperties");
        if (processDataPropertiesNode != null) {
            List<ValuedDataObject> dataObjects = BpmnJsonConverterUtil.convertJsonToDataProperties(processDataPropertiesNode, (BaseElement)subProcess);
            subProcess.setDataObjects(dataObjects);
            subProcess.getFlowElements().addAll(dataObjects);
        }
        if ("CollapsedSubProcess".equals(BpmnJsonConverterUtil.getStencilId(elementNode))) {
            GraphicInfo graphicInfo = this.model.getGraphicInfo(BpmnJsonConverterUtil.getElementId(elementNode));
            graphicInfo.setExpanded(Boolean.valueOf(false));
        }
        return subProcess;
    }
}

