/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.Optional;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.provisioning.api.data.RelationshipTypeDataBinder;

public class RelationshipTypeDataBinderImpl
implements RelationshipTypeDataBinder {
    protected final AnyTypeDAO anyTypeDAO;
    protected final EntityFactory entityFactory;

    public RelationshipTypeDataBinderImpl(AnyTypeDAO anyTypeDAO, EntityFactory entityFactory) {
        this.anyTypeDAO = anyTypeDAO;
        this.entityFactory = entityFactory;
    }

    public RelationshipType create(RelationshipTypeTO relationshipTypeTO) {
        RelationshipType relationshipType = (RelationshipType)this.entityFactory.newEntity(RelationshipType.class);
        relationshipType.setLeftEndAnyType((AnyType)Optional.ofNullable(relationshipTypeTO.getLeftEndAnyType()).flatMap(arg_0 -> ((AnyTypeDAO)this.anyTypeDAO).findById(arg_0)).orElseThrow(() -> new NotFoundException("AnyType " + relationshipTypeTO.getLeftEndAnyType())));
        relationshipType.setRightEndAnyType((AnyType)Optional.ofNullable(relationshipTypeTO.getRightEndAnyType()).flatMap(arg_0 -> ((AnyTypeDAO)this.anyTypeDAO).findById(arg_0)).orElseThrow(() -> new NotFoundException("AnyType " + relationshipTypeTO.getRightEndAnyType())));
        this.update(relationshipType, relationshipTypeTO);
        return relationshipType;
    }

    public void update(RelationshipType relationshipType, RelationshipTypeTO relationshipTypeTO) {
        if (relationshipType.getKey() == null) {
            relationshipType.setKey(relationshipTypeTO.getKey());
        }
        relationshipType.setDescription(relationshipTypeTO.getDescription());
    }

    public RelationshipTypeTO getRelationshipTypeTO(RelationshipType relationshipType) {
        RelationshipTypeTO relationshipTypeTO = new RelationshipTypeTO();
        relationshipTypeTO.setKey(relationshipType.getKey());
        relationshipTypeTO.setDescription(relationshipType.getDescription());
        relationshipTypeTO.setLeftEndAnyType(relationshipType.getLeftEndAnyType().getKey());
        relationshipTypeTO.setRightEndAnyType(relationshipType.getRightEndAnyType().getKey());
        return relationshipTypeTO;
    }
}

