/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.BaseRegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyRequest;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class PermifyRegisteredServiceAccessStrategy
extends BaseRegisteredServiceAccessStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PermifyRegisteredServiceAccessStrategy.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final long serialVersionUID = -2108201604115278441L;
    private static final int DEPTH = 20;
    @ExpressionLanguageCapable
    private String apiUrl;
    @ExpressionLanguageCapable
    private String tenantId;
    @ExpressionLanguageCapable
    private String entityType;
    @ExpressionLanguageCapable
    private String subjectType;
    @ExpressionLanguageCapable
    private String subjectRelation;
    @ExpressionLanguageCapable
    private String permission;
    @ExpressionLanguageCapable
    private String token;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean authorizeRequest(RegisteredServiceAccessStrategyRequest request) throws Throwable {
        boolean bl;
        InputStream content;
        HttpResponse response;
        block10: {
            SpringExpressionLanguageValueResolver expressionResolver = SpringExpressionLanguageValueResolver.getInstance();
            PermifyRequest permifyRequest = this.buildPermifyRequest(request);
            String url = StringUtils.removeEnd((String)expressionResolver.resolve(this.apiUrl), (String)"/");
            String tenant = StringUtils.removeEnd((String)expressionResolver.resolve(this.tenantId), (String)"/");
            String permifyUrl = String.format("%s/v1/tenants/%s/permissions/check", url, tenant);
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authorization", "Bearer " + expressionResolver.resolve(this.token));
            headers.put("Content-Type", "application/json");
            HttpExecutionRequest exec = HttpExecutionRequest.builder().method(HttpMethod.POST).url(permifyUrl).headers(headers).entity(permifyRequest.toJson()).build();
            response = null;
            LOGGER.debug("Submitting authorization request to [{}] for [{}]", (Object)permifyUrl, (Object)permifyRequest);
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            content = ((HttpEntityContainer)response).getEntity().getContent();
            String results = IOUtils.toString((InputStream)content, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("Received response from endpoint [{}] as [{}]", (Object)url, (Object)results);
            Map payload = (Map)MAPPER.readValue(results, Map.class);
            String result = (String)payload.get("can");
            bl = "CHECK_RESULT_ALLOWED".equalsIgnoreCase(result);
            if (content == null) break block10;
            content.close();
        }
        HttpUtils.close((HttpResponse)response);
        return bl;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (content != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                        HttpUtils.close(response);
                    }
                }
                catch (Throwable throwable3) {
                    HttpUtils.close(response);
                    throw throwable3;
                }
            }
        }
        return false;
    }

    protected PermifyRequest buildPermifyRequest(RegisteredServiceAccessStrategyRequest request) {
        SpringExpressionLanguageValueResolver expressionResolver = SpringExpressionLanguageValueResolver.getInstance();
        PermifyEntity entity = new PermifyEntity((String)StringUtils.defaultIfBlank((CharSequence)expressionResolver.resolve(this.entityType), (CharSequence)"application"), String.valueOf(request.getRegisteredService().getId()));
        PermifySubject subject = new PermifySubject((String)StringUtils.defaultIfBlank((CharSequence)expressionResolver.resolve(this.subjectType), (CharSequence)"user"), request.getPrincipalId(), (String)StringUtils.defaultIfBlank((CharSequence)expressionResolver.resolve(this.subjectRelation), (CharSequence)"owner"));
        PermifyContext context = new PermifyContext(Map.of("service", request.getService().getId(), "attributes", request.getAttributes()));
        return new PermifyRequest(entity, expressionResolver.resolve(this.permission), subject, context, new PermifyMetadata(20));
    }

    @Override
    @Generated
    public String toString() {
        return "PermifyRegisteredServiceAccessStrategy(super=" + super.toString() + ", apiUrl=" + this.apiUrl + ", tenantId=" + this.tenantId + ", entityType=" + this.entityType + ", subjectType=" + this.subjectType + ", subjectRelation=" + this.subjectRelation + ", permission=" + this.permission + ", token=" + this.token + ")";
    }

    @Generated
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }

    @Generated
    public String getSubjectType() {
        return this.subjectType;
    }

    @Generated
    public String getSubjectRelation() {
        return this.subjectRelation;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setEntityType(String entityType) {
        this.entityType = entityType;
        return this;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setSubjectType(String subjectType) {
        this.subjectType = subjectType;
        return this;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setSubjectRelation(String subjectRelation) {
        this.subjectRelation = subjectRelation;
        return this;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setPermission(String permission) {
        this.permission = permission;
        return this;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy setToken(String token) {
        this.token = token;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PermifyRegisteredServiceAccessStrategy)) {
            return false;
        }
        PermifyRegisteredServiceAccessStrategy other = (PermifyRegisteredServiceAccessStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$apiUrl = this.apiUrl;
        String other$apiUrl = other.apiUrl;
        if (this$apiUrl == null ? other$apiUrl != null : !this$apiUrl.equals(other$apiUrl)) {
            return false;
        }
        String this$tenantId = this.tenantId;
        String other$tenantId = other.tenantId;
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$entityType = this.entityType;
        String other$entityType = other.entityType;
        if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
            return false;
        }
        String this$subjectType = this.subjectType;
        String other$subjectType = other.subjectType;
        if (this$subjectType == null ? other$subjectType != null : !this$subjectType.equals(other$subjectType)) {
            return false;
        }
        String this$subjectRelation = this.subjectRelation;
        String other$subjectRelation = other.subjectRelation;
        if (this$subjectRelation == null ? other$subjectRelation != null : !this$subjectRelation.equals(other$subjectRelation)) {
            return false;
        }
        String this$permission = this.permission;
        String other$permission = other.permission;
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        String this$token = this.token;
        String other$token = other.token;
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PermifyRegisteredServiceAccessStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $apiUrl = this.apiUrl;
        result = result * 59 + ($apiUrl == null ? 43 : $apiUrl.hashCode());
        String $tenantId = this.tenantId;
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $entityType = this.entityType;
        result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
        String $subjectType = this.subjectType;
        result = result * 59 + ($subjectType == null ? 43 : $subjectType.hashCode());
        String $subjectRelation = this.subjectRelation;
        result = result * 59 + ($subjectRelation == null ? 43 : $subjectRelation.hashCode());
        String $permission = this.permission;
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        String $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public PermifyRegisteredServiceAccessStrategy() {
    }

    public record PermifyRequest(PermifyEntity entity, String permission, PermifySubject subject, PermifyContext context, PermifyMetadata metadata) {
        public String toJson() {
            return (String)FunctionUtils.doUnchecked(() -> MAPPER.writeValueAsString((Object)this));
        }
    }

    public record PermifyEntity(String type, String id) {
    }

    public record PermifySubject(String type, String id, String relation) {
    }

    public record PermifyContext(Map data) {
    }

    public record PermifyMetadata(int depth) {
    }
}

