/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.velocity;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ObjectFactory;
import org.apache.struts2.StrutsException;
import org.apache.struts2.inject.Container;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.util.ValueStack;
import org.apache.struts2.views.TagLibraryDirectiveProvider;
import org.apache.struts2.views.util.ContextUtil;
import org.apache.struts2.views.velocity.StrutsVelocityContext;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.struts2.views.velocity.VelocityStrutsUtil;
import org.apache.struts2.views.velocity.VelocityTools;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class StrutsVelocityManager
implements VelocityManager {
    private static final Logger LOG = LogManager.getLogger(StrutsVelocityManager.class);
    private ObjectFactory objectFactory;
    public static final String DEFAULT_CONFIG_FILE = "velocity.properties";
    public static final String KEY_VELOCITY_STRUTS_CONTEXT = ".KEY_velocity.struts2.context";
    private VelocityEngine velocityEngine;
    private VelocityTools velocityTools;
    private List<String> chainedContextNames = Collections.emptyList();
    private Properties velocityProperties;
    private String customConfigFile;
    private List<TagLibraryDirectiveProvider> tagLibraries;

    @Inject
    public void setObjectFactory(ObjectFactory fac) {
        this.objectFactory = fac;
    }

    @Inject
    public void setContainer(Container container) {
        this.tagLibraries = container.getInstanceNames(TagLibraryDirectiveProvider.class).stream().map(prefix -> (TagLibraryDirectiveProvider)container.getInstance(TagLibraryDirectiveProvider.class, prefix)).toList();
    }

    @Override
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    @Override
    public Context createContext(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        Context context = null;
        if (this.velocityTools != null) {
            context = this.velocityTools.createContext();
        }
        if (context == null) {
            context = this.buildContext(stack, req, res);
        }
        req.setAttribute(KEY_VELOCITY_STRUTS_CONTEXT, (Object)context);
        return context;
    }

    protected Context buildContext(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        List<VelocityContext> chainedContexts = this.prepareChainedContexts(req, res, stack.getContext());
        StrutsVelocityContext context = new StrutsVelocityContext(chainedContexts, stack);
        ContextUtil.getStandardContext((ValueStack)stack, (HttpServletRequest)req, (HttpServletResponse)res).forEach((arg_0, arg_1) -> ((Context)context).put(arg_0, arg_1));
        VelocityStrutsUtil util = new VelocityStrutsUtil(this.velocityEngine, (Context)context, stack, req, res);
        context.put("struts", (Object)util);
        return context;
    }

    protected List<VelocityContext> prepareChainedContexts(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Map<String, Object> extraContext) {
        ArrayList<VelocityContext> contextList = new ArrayList<VelocityContext>();
        for (String className : this.chainedContextNames) {
            try {
                VelocityContext velocityContext = (VelocityContext)this.objectFactory.buildBean(className, extraContext);
                contextList.add(velocityContext);
            }
            catch (Exception e) {
                LOG.warn("Unable to instantiate chained VelocityContext {}, skipping", (Object)className, (Object)e);
            }
        }
        return contextList;
    }

    @Override
    public synchronized void init(ServletContext context) {
        if (this.velocityEngine != null) {
            return;
        }
        this.velocityEngine = this.newVelocityEngine(context);
        if (this.velocityTools != null) {
            this.velocityTools.init(context, this.velocityEngine);
        }
    }

    protected Properties loadConfiguration(ServletContext context) {
        String userDirective;
        if (context == null) {
            throw new IllegalArgumentException("Error attempting to create a loadConfiguration from a null ServletContext!");
        }
        Properties properties = new Properties();
        this.applyDefaultConfiguration(context, properties);
        String defaultUserDirective = properties.getProperty("userdirective");
        this.applyUserConfiguration(context, properties);
        if (this.velocityProperties != null) {
            this.velocityProperties.stringPropertyNames().forEach(k -> properties.setProperty((String)k, this.velocityProperties.getProperty((String)k)));
        }
        String newDirective = StringUtils.isBlank((CharSequence)(userDirective = properties.getProperty("userdirective"))) ? defaultUserDirective : userDirective.strip() + "," + defaultUserDirective;
        properties.setProperty("userdirective", newDirective);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing Velocity with the following properties ...");
            properties.stringPropertyNames().forEach(k -> LOG.debug("    '{}' = '{}'", k, (Object)properties.getProperty((String)k)));
        }
        return properties;
    }

    private void applyUserConfiguration(ServletContext context, Properties properties) {
        String configFile = Objects.requireNonNullElse(this.customConfigFile, DEFAULT_CONFIG_FILE).trim();
        try {
            if (this.loadFile(properties, context.getRealPath(configFile))) {
                return;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to load Velocity configuration from servlet context path", (Throwable)e);
        }
        try {
            if (this.loadFile(properties, context.getRealPath("/WEB-INF/" + configFile))) {
                return;
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to load Velocity configuration from WEB-INF path", (Throwable)e);
        }
        try {
            this.loadClassPathFile(properties, configFile);
        }
        catch (IOException e) {
            LOG.warn("Unable to load Velocity configuration from classpath", (Throwable)e);
        }
    }

    private boolean loadClassPathFile(Properties properties, String configFile) throws IOException {
        try (InputStream is = StrutsVelocityManager.class.getClassLoader().getResourceAsStream(configFile);){
            if (is == null) {
                boolean bl = false;
                return bl;
            }
            properties.load(is);
            LOG.info("Initializing Velocity using {} from classpath", (Object)configFile);
            boolean bl = true;
            return bl;
        }
    }

    private boolean loadFile(Properties properties, String fileName) throws IOException {
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        if (!file.isFile()) {
            return false;
        }
        try (FileInputStream is = new FileInputStream(file);){
            properties.load(is);
            LOG.info("Initializing Velocity using {}", (Object)(file.getCanonicalPath() + " from file system"));
            boolean bl = true;
            return bl;
        }
    }

    @Inject(value="struts.velocity.configfile")
    public void setCustomConfigFile(String customConfigFile) {
        this.customConfigFile = customConfigFile;
    }

    @Inject(value="struts.velocity.toolboxlocation")
    public void setToolBoxLocation(String toolboxLocation) {
        if (!StringUtils.isBlank((CharSequence)toolboxLocation)) {
            this.velocityTools = new VelocityTools(toolboxLocation);
        }
    }

    public VelocityTools getVelocityTools() {
        return this.velocityTools;
    }

    @Inject(value="struts.velocity.contexts")
    public void setChainedContexts(String contexts) {
        this.chainedContextNames = Arrays.stream(contexts.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    protected VelocityEngine newVelocityEngine(ServletContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Error attempting to create a new VelocityEngine from a null ServletContext!");
        }
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)context);
        try {
            velocityEngine.init(this.loadConfiguration(context));
        }
        catch (Exception e) {
            throw new StrutsException("Unable to instantiate VelocityEngine!", (Throwable)e);
        }
        return velocityEngine;
    }

    private void applyDefaultConfiguration(ServletContext context, Properties properties) {
        String realPath;
        LOG.debug("Load a default resource loader definition if there isn't one present.");
        if (properties.getProperty("resource.loader") == null) {
            properties.setProperty("resource.loader", "strutsfile, strutsclass");
        }
        if ((realPath = context.getRealPath("")) != null) {
            this.setStrutsFileResourceLoader(properties, realPath);
        } else {
            this.clearStrutsFileResourceLoader(properties);
        }
        this.setStrutsClasspathResourceLoader(properties);
        String directives = this.tagLibraries.stream().map(TagLibraryDirectiveProvider::getDirectiveClasses).flatMap(Collection::stream).map(directive -> directive.getName() + ",").collect(Collectors.joining());
        String userDirective = properties.getProperty("userdirective");
        String newDirective = StringUtils.isBlank((CharSequence)userDirective) ? directives : userDirective.strip() + "," + directives;
        properties.setProperty("userdirective", newDirective);
    }

    private void setStrutsFileResourceLoader(Properties properties, String realPath) {
        properties.setProperty("strutsfile.resource.loader.description", "Velocity File Resource Loader");
        properties.setProperty("strutsfile.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        properties.setProperty("strutsfile.resource.loader.path", realPath);
        properties.setProperty("strutsfile.resource.loader.modificationCheckInterval", "2");
        properties.setProperty("strutsfile.resource.loader.cache", "true");
    }

    private void clearStrutsFileResourceLoader(Properties properties) {
        String prop = properties.getProperty("resource.loader").replace("strutsfile,", "").replace(", strutsfile", "").replace("strutsfile", "");
        properties.setProperty("resource.loader", prop);
    }

    private void setStrutsClasspathResourceLoader(Properties properties) {
        properties.setProperty("strutsclass.resource.loader.description", "Velocity Classpath Resource Loader");
        properties.setProperty("strutsclass.resource.loader.class", "org.apache.struts2.views.velocity.StrutsResourceLoader");
        properties.setProperty("strutsclass.resource.loader.modificationCheckInterval", "2");
        properties.setProperty("strutsclass.resource.loader.cache", "true");
    }

    public Properties getVelocityProperties() {
        return this.velocityProperties;
    }

    public void setVelocityProperties(Properties velocityProperties) {
        this.velocityProperties = velocityProperties;
    }
}

