/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRCommonImage;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.fill.JRTemplateGraphicElement;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.ObjectUtils;

public class JRTemplateImage
extends JRTemplateGraphicElement
implements JRCommonImage {
    private static final long serialVersionUID = 10200L;
    private ScaleImageEnum scaleImage;
    private RotationEnum rotation;
    private Boolean isUsingCache = Boolean.TRUE;
    private HorizontalImageAlignEnum horizontalImageAlign;
    private VerticalImageAlignEnum verticalImageAlign;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorType = OnErrorTypeEnum.ERROR;
    private String linkType;
    private String linkTarget;
    private JRLineBox lineBox;

    protected JRTemplateImage(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider, JRImage image) {
        super(origin, defaultStyleProvider);
        this.setImage(image);
    }

    public JRTemplateImage(JROrigin origin, JRDefaultStyleProvider defaultStyleProvider) {
        super(origin, defaultStyleProvider);
        this.lineBox = new JRBaseLineBox(this);
        this.linePen = new JRBasePen(this);
    }

    protected void setImage(JRImage image) {
        super.setGraphicElement(image);
        this.lineBox = image.getLineBox().clone(this);
        this.setScaleImage(image.getOwnScaleImage());
        this.setRotation(image.getOwnRotation());
        this.setUsingCache(image.getUsingCache());
        this.setHorizontalImageAlign(image.getOwnHorizontalImageAlign());
        this.setVerticalImageAlign(image.getOwnVerticalImageAlign());
        this.setLazy(image.isLazy());
        this.setOnErrorType(image.getOnErrorType());
        this.setLinkType(image.getLinkType());
        this.setLinkTarget(image.getLinkTarget());
    }

    public void copyLineBox(JRLineBox box) {
        this.lineBox = box.clone(this);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImage() {
        return this.getStyleResolver().getScaleImage(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImage() {
        return this.scaleImage;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImage) {
        this.scaleImage = scaleImage;
    }

    @Override
    public RotationEnum getRotation() {
        return this.getStyleResolver().getRotation(this);
    }

    @Override
    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        this.rotation = rotation;
    }

    public boolean isUsingCache() {
        return this.isUsingCache == null ? true : this.isUsingCache;
    }

    public void setUsingCache(boolean isUsingCache) {
        this.isUsingCache = isUsingCache;
    }

    public void setUsingCache(Boolean isUsingCache) {
        this.isUsingCache = isUsingCache;
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        this.horizontalImageAlign = horizontalImageAlign;
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        this.verticalImageAlign = verticalImageAlign;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public void setLazy(boolean isLazy) {
        this.isLazy = isLazy;
    }

    public OnErrorTypeEnum getOnErrorType() {
        return this.onErrorType;
    }

    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        this.onErrorType = onErrorType;
    }

    public HyperlinkTypeEnum getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this.getLinkType());
    }

    protected void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public HyperlinkTargetEnum getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this.getLinkTarget());
    }

    protected void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public int getHashCode() {
        ObjectUtils.HashCode hash = ObjectUtils.hash();
        this.addGraphicHash(hash);
        hash.add(this.scaleImage);
        hash.add(this.rotation);
        hash.add(this.isUsingCache);
        hash.add(this.horizontalImageAlign);
        hash.add(this.verticalImageAlign);
        hash.add(this.isLazy);
        hash.add(this.onErrorType);
        hash.add(this.linkType);
        hash.add(this.linkTarget);
        hash.addIdentical(this.lineBox);
        return hash.getHashCode();
    }

    @Override
    public boolean isIdentical(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JRTemplateImage)) {
            return false;
        }
        JRTemplateImage template = (JRTemplateImage)object;
        return this.graphicIdentical(template) && ObjectUtils.equals(this.scaleImage, template.scaleImage) && ObjectUtils.equals(this.rotation, template.rotation) && ObjectUtils.equals(this.isUsingCache, template.isUsingCache) && ObjectUtils.equals(this.horizontalImageAlign, template.horizontalImageAlign) && ObjectUtils.equals(this.verticalImageAlign, template.verticalImageAlign) && ObjectUtils.equals(this.isLazy, template.isLazy) && ObjectUtils.equals(this.onErrorType, template.onErrorType) && ObjectUtils.equals(this.linkType, template.linkType) && ObjectUtils.equals(this.linkTarget, template.linkTarget) && ObjectUtils.identical(this.lineBox, template.lineBox);
    }

    @Override
    public void populateStyle() {
        super.populateStyle();
        this.scaleImage = this.getScaleImage();
        this.rotation = this.getRotation();
        this.horizontalImageAlign = this.getHorizontalImageAlign();
        this.verticalImageAlign = this.getVerticalImageAlign();
        if (this.lineBox != null) {
            this.lineBox.populateStyle();
        }
    }
}

