/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.ValidationCycle;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Digits;
import net.sf.oval.internal.Log;

public class DigitsCheck
extends AbstractAnnotationCheck<Digits> {
    private static final Log LOG = Log.getLog(DigitsCheck.class);
    private static final long serialVersionUID = 1L;
    private int maxFraction = Integer.MAX_VALUE;
    private int maxInteger = Integer.MAX_VALUE;
    private int minFraction = 0;
    private int minInteger = 0;

    @Override
    public void configure(Digits constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMinInteger(constraintAnnotation.minInteger());
        this.setMaxInteger(constraintAnnotation.maxInteger());
        this.setMinFraction(constraintAnnotation.minFraction());
        this.setMaxFraction(constraintAnnotation.maxFraction());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("maxInteger", Integer.toString(this.maxInteger));
        messageVariables.put("minInteger", Integer.toString(this.minInteger));
        messageVariables.put("maxFraction", Integer.toString(this.maxFraction));
        messageVariables.put("minFraction", Integer.toString(this.minFraction));
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public int getMaxFraction() {
        return this.maxFraction;
    }

    public int getMaxInteger() {
        return this.maxInteger;
    }

    public int getMinFraction() {
        return this.minFraction;
    }

    public int getMinInteger() {
        return this.minInteger;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, ValidationCycle cycle) {
        int fractLen;
        int intLen;
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Integer) {
            int value = (Integer)valueToValidate;
            intLen = value == 0 ? 1 : (int)Math.log10(value) + 1;
            fractLen = 0;
        } else if (valueToValidate instanceof Long) {
            long value = (Long)valueToValidate;
            intLen = value == 0L ? 1 : (int)Math.log10(value) + 1;
            fractLen = 0;
        } else if (valueToValidate instanceof Short) {
            short value = (Short)valueToValidate;
            intLen = value == 0 ? 1 : (int)Math.log10(value) + 1;
            fractLen = 0;
        } else if (valueToValidate instanceof Byte) {
            byte value = (Byte)valueToValidate;
            intLen = value == 0 ? 1 : (int)Math.log10(value) + 1;
            fractLen = 0;
        } else if (valueToValidate instanceof BigInteger) {
            long value = ((BigInteger)valueToValidate).longValue();
            intLen = value == 0L ? 1 : (int)Math.log10(value) + 1;
            fractLen = 0;
        } else {
            BigDecimal value = null;
            if (valueToValidate instanceof BigDecimal) {
                value = (BigDecimal)valueToValidate;
            } else {
                try {
                    value = new BigDecimal(valueToValidate.toString());
                }
                catch (NumberFormatException ex) {
                    LOG.debug("Failed to parse numeric value: " + valueToValidate, ex);
                    return false;
                }
            }
            int valueScale = value.scale();
            long longValue = value.longValue();
            intLen = longValue == 0L ? 1 : (int)Math.log10(longValue) + 1;
            int n = fractLen = valueScale > 0 ? valueScale : 0;
        }
        return intLen <= this.maxInteger && intLen >= this.minInteger && fractLen <= this.maxFraction && fractLen >= this.minFraction;
    }

    public void setMaxFraction(int maxFraction) {
        this.maxFraction = maxFraction;
        this.requireMessageVariablesRecreation();
    }

    public void setMaxInteger(int maxInteger) {
        this.maxInteger = maxInteger;
        this.requireMessageVariablesRecreation();
    }

    public void setMinFraction(int minFraction) {
        this.minFraction = minFraction;
        this.requireMessageVariablesRecreation();
    }

    public void setMinInteger(int minInteger) {
        this.minInteger = minInteger;
        this.requireMessageVariablesRecreation();
    }
}

