/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.storm.command.AdminCommands;
import org.apache.storm.command.CLI;
import org.apache.storm.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.storm.shade.org.apache.zookeeper.CreateMode;
import org.apache.storm.shade.org.apache.zookeeper.KeeperException;
import org.apache.storm.shade.org.apache.zookeeper.Op;
import org.apache.storm.shade.org.apache.zookeeper.OpResult;
import org.apache.storm.shade.org.apache.zookeeper.Transaction;
import org.apache.storm.shade.org.apache.zookeeper.Watcher;
import org.apache.storm.shade.org.apache.zookeeper.ZooKeeper;
import org.apache.storm.shade.org.apache.zookeeper.ZooKeeperMain;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.shade.org.apache.zookeeper.data.Stat;
import org.apache.storm.utils.ObjectReader;

public class ZkCli
implements AdminCommands.AdminCommand {
    @Override
    public void run(String[] args, Map<String, Object> conf, String command) throws Exception {
        String connectionString;
        List servers = (List)conf.get("storm.zookeeper.servers");
        int port = ObjectReader.getInt((Object)conf.get("storm.zookeeper.port"));
        String root = (String)conf.get("storm.zookeeper.root");
        Map<String, Object> cl = CLI.opt("s", "server", null, CLI.AS_STRING, CLI.LAST_WINS).opt("t", "time-out", ObjectReader.getInt((Object)conf.get("storm.zookeeper.session.timeout")), CLI.AS_INT, CLI.LAST_WINS).boolOpt("w", "write").boolOpt("n", "no-root").opt("j", "jaas", conf.get("java.security.auth.login.config"), CLI.AS_STRING, CLI.LAST_WINS).boolOpt("h", "help").parse(args);
        if (((Boolean)cl.get("h")).booleanValue()) {
            this.printCliHelp(command, System.out);
            return;
        }
        String jaas = (String)cl.get("j");
        if (jaas != null && !jaas.isEmpty()) {
            System.setProperty("java.security.auth.login.config", jaas);
        }
        if ((connectionString = (String)cl.get("s")) == null) {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (String zkServer : servers) {
                if (!isFirst) {
                    sb.append(',');
                }
                isFirst = false;
                sb.append(zkServer).append(':').append(port);
            }
            if (!((Boolean)cl.get("n")).booleanValue()) {
                sb.append(root);
            }
            connectionString = sb.toString();
        }
        boolean readOnly = (Boolean)cl.get("w") == false;
        int timeout = (Integer)cl.get("t");
        ReadOnlyZookeeper zk = readOnly ? new ReadOnlyZookeeper(connectionString, timeout, watchedEvent -> {}) : new ZooKeeper(connectionString, timeout, watchedEvent -> {});
        ZooKeeperMain main = new ZooKeeperMain((ZooKeeper)zk);
        main.run();
    }

    @Override
    public void printCliHelp(String command, PrintStream out) {
        out.println(command + " [<opts>]:");
        out.println("\tStart a zookeeper shell");
        out.println();
        out.println("\t-s --server <connection string>: Set the connection string to use, defaults to storm connection string.");
        out.println("\t-t --time-out <timeout>:         Set the timeout to use, defaults to storm zookeeper timeout.");
        out.println("\t-w --write:                      Allow for writes, defaults to read only, we don't want to cause problems.");
        out.println("\t-n --no-root:                    Don't include the storm root on the default connection string.");
        out.println("\t-j --jaas <jaas_file>:           Include a jaas file that should be used when authenticating with\n\t\tZK defaults to the java.security.auth.login.config conf.");
    }

    private static class ReadOnlyZookeeper
    extends ZooKeeper {
        ReadOnlyZookeeper(String connectionString, int timeout, Watcher watcher) throws IOException {
            super(connectionString, timeout, watcher);
        }

        public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NOTREADONLY, (String)path);
        }

        public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
            throw new IllegalArgumentException("In Read Only Mode");
        }

        public void delete(String path, int version) throws KeeperException {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NOTREADONLY, (String)path);
        }

        public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
            throw new IllegalArgumentException("In Read Only Mode");
        }

        public List<OpResult> multi(Iterable<Op> ops) throws KeeperException {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NOTREADONLY, (String)"multi opt");
        }

        public Transaction transaction() {
            throw new IllegalArgumentException("In Read Only Mode");
        }

        public Stat setData(String path, byte[] data, int version) throws KeeperException {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NOTREADONLY, (String)path);
        }

        public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
            throw new IllegalArgumentException("In Read Only Mode");
        }

        public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException {
            throw KeeperException.create((KeeperException.Code)KeeperException.Code.NOTREADONLY, (String)path);
        }

        public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
            throw new IllegalArgumentException("In Read Only Mode");
        }
    }
}

