/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.io.File;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.logging.org.slf4j.MDC;

public abstract class AbstractBrokerRunnable
implements Runnable {
    protected final BrokerIdentity brokerIdentity;
    private static final String MDC_BROKER_CONTAINER_LOG_DIR = "brokerContainerLogDir";

    public AbstractBrokerRunnable(BrokerIdentity brokerIdentity) {
        this.brokerIdentity = brokerIdentity;
    }

    public abstract void run0();

    @Override
    public void run() {
        try {
            if (this.brokerIdentity.isInBrokerContainer()) {
                MDC.put((String)MDC_BROKER_CONTAINER_LOG_DIR, (String)(File.separator + this.brokerIdentity.getCanonicalName()));
            }
            this.run0();
        }
        finally {
            MDC.clear();
        }
    }
}

