/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ParamContextClient;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class ImportParamContext
extends AbstractNiFiCommand<StringResult> {
    public ImportParamContext() {
        super("import-param-context", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Imports a parameter context using the output from the export-param-context command as the context to import. If the context name and context description arguments are specified, they will override what is in the context json. All inherited parameter contexts are expected to have been imported already, otherwise the operation will fail.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_NAME.createOption());
        this.addOption(CommandOption.PARAM_CONTEXT_DESC.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextName = this.getArg(properties, CommandOption.PARAM_CONTEXT_NAME);
        String paramContextDesc = this.getArg(properties, CommandOption.PARAM_CONTEXT_DESC);
        String inputSource = this.getRequiredArg(properties, CommandOption.INPUT_SOURCE);
        String paramContextJson = this.getInputSourceContent(inputSource);
        ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
        ParameterContextDTO paramContext = (ParameterContextDTO)objectMapper.readValue(paramContextJson, ParameterContextDTO.class);
        if (!StringUtils.isBlank((CharSequence)paramContextName)) {
            paramContext.setName(paramContextName);
        }
        if (!StringUtils.isBlank((CharSequence)paramContextDesc)) {
            paramContext.setDescription(paramContextDesc);
        }
        ParameterContextEntity paramContextEntity = new ParameterContextEntity();
        paramContextEntity.setComponent(paramContext);
        paramContextEntity.setRevision(this.getInitialRevisionDTO());
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity createdParamContext = paramContextClient.createParamContext(paramContextEntity);
        return new StringResult(createdParamContext.getId(), this.isInteractive());
    }
}

