/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import lombok.Generated;
import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.ProgressLoggerEmpty;
import org.flywaydb.core.ProgressLoggerJson;
import org.flywaydb.core.api.ClassProvider;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.migration.JavaMigration;
import org.flywaydb.core.api.pattern.ValidatePattern;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.extensibility.ConfigurationProvider;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.DataSourceModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.FlywayEnvironmentModel;
import org.flywaydb.core.internal.configuration.models.FlywayModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentProvisioner;
import org.flywaydb.core.internal.configuration.resolvers.EnvironmentResolver;
import org.flywaydb.core.internal.configuration.resolvers.PropertyResolver;
import org.flywaydb.core.internal.configuration.resolvers.ProvisionerMode;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.DriverDataSource;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.nc.NativeConnectorsModeUtils;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.proprietaryInterfaces.CherryPickConfiguration;
import org.flywaydb.core.internal.scanner.ClasspathClassScanner;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.Locations;
import org.flywaydb.core.internal.util.MergeUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ClassicConfiguration
implements Configuration {
    @Generated
    private static final Log LOG = LogFactory.getLog(ClassicConfiguration.class);
    public static final String TEMP_ENVIRONMENT_NAME = "tempConfigEnvironment";
    private static final Pattern ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN = Pattern.compile("\"([^\"]*)\"");
    private static final Pattern ANY_WORD_BETWEEN_TWO_DOTS_PATTERN = Pattern.compile("\\.(.*?)\\.");
    private final Map<String, DataSourceModel> dataSources = new HashMap<String, DataSourceModel>();
    private final Map<String, ResolvedEnvironment> resolvedEnvironments = new HashMap<String, ResolvedEnvironment>();
    private final Collection<Callback> callbacks = new ArrayList<Callback>();
    private ClasspathClassScanner classScanner;
    private EnvironmentResolver environmentResolver;
    private ConfigurationModel modernConfig = ConfigurationModel.defaults();
    private String workingDirectory;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private ResourceProvider resourceProvider;
    private ClassProvider<JavaMigration> javaMigrationClassProvider;
    private JavaMigration[] javaMigrations = new JavaMigration[0];
    private MigrationResolver[] resolvers = new MigrationResolver[0];
    private OutputStream dryRunOutput;
    private PluginRegister pluginRegister = new PluginRegister();

    public ClassicConfiguration(ConfigurationModel modernConfig) {
        this.classScanner = new ClasspathClassScanner(this.classLoader);
        this.modernConfig = modernConfig;
    }

    public ClassicConfiguration() {
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    public ClassicConfiguration(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    public ClassicConfiguration(Configuration configuration) {
        this(configuration.getClassLoader());
        this.configure(configuration);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.classScanner = new ClasspathClassScanner(this.classLoader);
    }

    private static void parsePropertiesFromConfigExtension(Map<? super String, Map<String, Object>> configExtensionsPropertyMap, Collection<? super String> keysToRemove, Map.Entry<String, String> params, String fixedKey, ConfigurationExtension configExtension) {
        String rootKey;
        List<String> fields = Arrays.stream(configExtension.getClass().getDeclaredFields()).map(Field::getName).toList();
        if (keysToRemove.contains(params.getKey()) && configExtension.isStub()) {
            return;
        }
        String string = rootKey = fixedKey.contains(".") ? fixedKey.substring(0, fixedKey.indexOf(".")) : fixedKey;
        if (fields.contains(rootKey)) {
            String[] value = params.getValue();
            if (!configExtensionsPropertyMap.containsKey(configExtension.getClass().toString())) {
                configExtensionsPropertyMap.put(configExtension.getClass().toString(), new HashMap());
            }
            if (fixedKey.contains(".")) {
                String[] path = fixedKey.split("\\.");
                Map<String, Object> currentConfigExtensionProperties = new HashMap();
                if (!configExtensionsPropertyMap.get(configExtension.getClass().toString()).containsKey(path[0])) {
                    configExtensionsPropertyMap.get(configExtension.getClass().toString()).put(path[0], currentConfigExtensionProperties);
                } else {
                    currentConfigExtensionProperties = (Map)configExtensionsPropertyMap.get(configExtension.getClass().toString()).get(path[0]);
                }
                ConfigurationExtension currentConfigExtension = configExtension;
                Field[] declaredFields = configExtension.getClass().getDeclaredFields();
                Field field = Arrays.stream(declaredFields).filter(f -> f.getName().equals(path[0])).findFirst().orElse(null);
                try {
                    currentConfigExtension = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    LOG.error("Failed to get configuration extension", e);
                }
                for (int i = 1; i < path.length; ++i) {
                    String currentPath = path[i];
                    try {
                        Field[] subFields = currentConfigExtension.getClass().getDeclaredFields();
                        field = Arrays.stream(subFields).filter(f -> f.getName().equals(currentPath)).findFirst().orElse(null);
                        if (field.getType() == List.class || field.getType() == String[].class) {
                            value = value.split(",");
                        } else {
                            currentConfigExtension = field.getType() == Boolean.class ? null : field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                    catch (Exception subFields) {
                        // empty catch block
                    }
                    if (i < path.length - 1) {
                        HashMap newValue = new HashMap();
                        currentConfigExtensionProperties.put(path[i], newValue);
                        currentConfigExtensionProperties = newValue;
                        continue;
                    }
                    currentConfigExtensionProperties.put(path[i], value);
                }
            } else {
                configExtensionsPropertyMap.get(configExtension.getClass().toString()).put(fixedKey, value);
            }
            keysToRemove.add(params.getKey());
        }
    }

    @Override
    public DataSource getDataSource() {
        DataSourceModel model = this.dataSources.getOrDefault(this.getCurrentEnvironmentName(), null);
        if (model != null && model.getDataSource() != null) {
            return model.getDataSource();
        }
        if (StringUtils.hasText(this.getUrl()) && NativeConnectorsModeUtils.canCreateDataSource(this)) {
            DriverDataSource dataSource = new DriverDataSource(this.classLoader, this.getDriver(), this.getUrl(), this.getUser(), this.getPassword(), this, this.getJdbcProperties());
            this.dataSources.put(this.getCurrentEnvironmentName(), new DataSourceModel(dataSource, true));
            return dataSource;
        }
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSources.put(this.getCurrentEnvironmentName(), new DataSourceModel(dataSource, false));
    }

    @Override
    public String getDefaultSchema() {
        if (this.getEnvironmentOverrides().getDefaultSchema() != null) {
            return this.getEnvironmentOverrides().getDefaultSchema();
        }
        return this.getModernFlyway().getDefaultSchema();
    }

    public void setDefaultSchema(String defaultSchema) {
        this.getModernFlyway().setDefaultSchema(defaultSchema);
    }

    public ResolvedEnvironment getCurrentResolvedEnvironment() {
        return this.getCurrentResolvedEnvironment(null);
    }

    public ResolvedEnvironment getCurrentResolvedEnvironment(ProgressLogger progress) {
        String envProvisionMode;
        ProvisionerMode provisionerMode;
        String envName = this.getCurrentEnvironmentName();
        ResolvedEnvironment resolved = this.getResolvedEnvironment(envName, provisionerMode = StringUtils.hasText(envProvisionMode = this.getModernFlyway().getProvisionMode()) ? ProvisionerMode.fromString(envProvisionMode) : ProvisionerMode.Provision, progress);
        if (resolved != null) {
            return resolved;
        }
        if ("-".equals(envName)) {
            return new ResolvedEnvironment();
        }
        throw new FlywayException("Environment '" + envName + "' not found. Check that this environment exists in your configuration.");
    }

    public ResolvedEnvironment getResolvedEnvironment(String envName) {
        return this.getResolvedEnvironment(envName, ProvisionerMode.Provision, null);
    }

    @Override
    public ResolvedEnvironment getResolvedEnvironment(String envName, ProvisionerMode provisionerMode, ProgressLogger progress) {
        ResolvedEnvironment cachedEnvironment;
        if (this.environmentResolver == null) {
            this.environmentResolver = new EnvironmentResolver(this.pluginRegister.getInstancesOf(PropertyResolver.class).stream().collect(Collectors.toMap(PropertyResolver::getName, x -> x)), this.pluginRegister.getInstancesOf(EnvironmentProvisioner.class).stream().collect(Collectors.toMap(EnvironmentProvisioner::getName, x -> x)));
        }
        if ((cachedEnvironment = this.resolvedEnvironments.get(envName)) != null && !provisionerMode.isHigherPriorityThan(cachedEnvironment.getProvisionerMode())) {
            return this.resolvedEnvironments.get(envName);
        }
        if (!this.modernConfig.getEnvironments().containsKey(envName)) {
            return null;
        }
        if (this.dataSources.containsKey(envName) && this.dataSources.get(envName).isDataSourceGenerated()) {
            this.dataSources.remove(envName);
        }
        EnvironmentModel unresolved = this.modernConfig.getEnvironments().get(envName);
        ResolvedEnvironment resolved = this.environmentResolver.resolve(envName, unresolved, provisionerMode, this, progress == null ? new ProgressLoggerEmpty() : progress);
        this.resolvedEnvironments.put(envName, resolved);
        return resolved;
    }

    private FlywayModel getModernFlyway() {
        return this.modernConfig.getFlyway();
    }

    private FlywayEnvironmentModel getEnvironmentOverrides() {
        try {
            return this.getCurrentUnresolvedEnvironment().getFlyway();
        }
        catch (FlywayException e) {
            return this.getModernFlyway();
        }
    }

    @Override
    public String[] getSchemas() {
        return (String[])this.getCurrentResolvedEnvironment().getSchemas().toArray(String[]::new);
    }

    public void setSchemas(String[] tokenizeToStringArray) {
        List<String> schemas = Arrays.stream(tokenizeToStringArray).collect(Collectors.toList());
        this.getCurrentUnresolvedEnvironment().setSchemas(schemas);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public boolean isReportEnabled() {
        if (this.getEnvironmentOverrides().getReportEnabled() != null) {
            return this.getEnvironmentOverrides().getReportEnabled();
        }
        return this.getModernFlyway().getReportEnabled() != null && this.getModernFlyway().getReportEnabled() != false;
    }

    public void setReportEnabled(Boolean reportEnabled) {
        this.getModernFlyway().setReportEnabled(reportEnabled);
    }

    @Override
    public Charset getEncoding() {
        if (this.getEnvironmentOverrides().getEncoding() != null) {
            return Charset.forName(this.getEnvironmentOverrides().getEncoding());
        }
        return Charset.forName(this.getModernFlyway().getEncoding());
    }

    public void setEncoding(Charset encoding) {
        this.getModernFlyway().setEncoding(encoding.name());
    }

    @Override
    public boolean isDetectEncoding() {
        if (this.getEnvironmentOverrides().getDetectEncoding() != null) {
            return this.getEnvironmentOverrides().getDetectEncoding();
        }
        return this.getModernFlyway().getDetectEncoding();
    }

    public void setDetectEncoding(boolean detectEncoding) {
        this.getModernFlyway().setDetectEncoding(detectEncoding);
    }

    @Override
    public String getReportFilename() {
        if (this.getEnvironmentOverrides().getReportFilename() != null) {
            return this.getEnvironmentOverrides().getReportFilename();
        }
        return this.getModernFlyway().getReportFilename();
    }

    public void setReportFilename(String reportFilename) {
        this.getModernFlyway().setReportFilename(reportFilename);
    }

    @Override
    public Map<String, ResolvedEnvironment> getCachedResolvedEnvironments() {
        return Map.copyOf(this.resolvedEnvironments);
    }

    @Override
    public Map<String, DataSourceModel> getCachedDataSources() {
        return Map.copyOf(this.dataSources);
    }

    @Override
    public Callback[] getCallbacks() {
        this.loadUnloadedCallbacks();
        return (Callback[])this.callbacks.toArray(Callback[]::new);
    }

    public void setCallbacks(Callback ... callbacks) {
        this.callbacks.clear();
        this.callbacks.addAll(Arrays.asList(callbacks));
    }

    @Override
    public MigrationResolver[] getResolvers() {
        List<String> resolversToAdd;
        List<String> list = resolversToAdd = this.getEnvironmentOverrides().getMigrationResolvers() != null ? this.getEnvironmentOverrides().getMigrationResolvers() : this.getModernFlyway().getMigrationResolvers();
        if (resolversToAdd != null) {
            ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>(Arrays.asList(this.resolvers));
            migrationResolvers.addAll(resolversToAdd.stream().filter(p -> Arrays.stream(this.resolvers).noneMatch(r -> r.getClass().getCanonicalName().equals(p))).map(p -> (MigrationResolver)ClassUtils.instantiate(p, this.classLoader)).toList());
            this.setResolvers((MigrationResolver[])migrationResolvers.toArray(MigrationResolver[]::new));
        }
        return this.resolvers;
    }

    public void setResolvers(MigrationResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public String getUrl() {
        return this.getCurrentResolvedEnvironment().getUrl();
    }

    public void setUrl(String url) {
        this.getCurrentUnresolvedEnvironment().setUrl(url);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
        this.licenseGuardJdbcUrl(url);
    }

    @Override
    public String getUser() {
        return this.getCurrentResolvedEnvironment().getUser();
    }

    public void setUser(String user) {
        this.getCurrentUnresolvedEnvironment().setUser(user);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public String getPassword() {
        return this.getCurrentResolvedEnvironment().getPassword();
    }

    public void setPassword(String password) {
        this.getCurrentUnresolvedEnvironment().setPassword(password);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public Location[] getLocations() {
        List<String> locationsList = this.getModernFlyway().getLocations();
        if (this.getEnvironmentOverrides().getLocations() != null) {
            locationsList = this.getEnvironmentOverrides().getLocations();
        }
        Locations locations = new Locations((String[])locationsList.toArray(String[]::new));
        return (Location[])locations.getLocations().toArray(Location[]::new);
    }

    @Override
    public Location[] getCallbackLocations() {
        Collection stringLocations = Optional.ofNullable(this.getEnvironmentOverrides().getCallbackLocations()).orElse(Optional.ofNullable(this.getModernFlyway().getCallbackLocations()).orElse(Collections.emptyList()));
        return (Location[])new Locations((String[])stringLocations.toArray(String[]::new)).getLocations().toArray(Location[]::new);
    }

    public void setLocations(Location ... locations) {
        this.getModernFlyway().setLocations(Arrays.stream(locations).map(Location::getDescriptor).collect(Collectors.toList()));
    }

    public void setCallbackLocations(Location ... callbackLocations) {
        this.getModernFlyway().setCallbackLocations(Arrays.stream(callbackLocations).map(Location::getDescriptor).collect(Collectors.toList()));
    }

    @Override
    public boolean isBaselineOnMigrate() {
        if (this.getEnvironmentOverrides().getBaselineOnMigrate() != null) {
            return this.getEnvironmentOverrides().getBaselineOnMigrate();
        }
        return this.getModernFlyway().getBaselineOnMigrate();
    }

    public void setBaselineOnMigrate(Boolean baselineOnMigrateProp) {
        this.getModernFlyway().setBaselineOnMigrate(baselineOnMigrateProp);
    }

    @Override
    public boolean isSkipExecutingMigrations() {
        if (this.getEnvironmentOverrides().getSkipExecutingMigrations() != null) {
            return this.getEnvironmentOverrides().getSkipExecutingMigrations();
        }
        return this.getModernFlyway().getSkipExecutingMigrations();
    }

    public void setSkipExecutingMigrations(boolean skipExecutingMigrations) {
        this.getModernFlyway().setSkipExecutingMigrations(skipExecutingMigrations);
    }

    @Override
    public boolean isOutOfOrder() {
        if (this.getEnvironmentOverrides().getOutOfOrder() != null) {
            return this.getEnvironmentOverrides().getOutOfOrder();
        }
        return this.getModernFlyway().getOutOfOrder();
    }

    public void setOutOfOrder(Boolean outOfOrderProp) {
        this.getModernFlyway().setOutOfOrder(outOfOrderProp);
    }

    @Override
    public ValidatePattern[] getIgnoreMigrationPatterns() {
        List<String> ignoreMigrationPatternsList = this.getModernFlyway().getIgnoreMigrationPatterns();
        if (this.getEnvironmentOverrides().getIgnoreMigrationPatterns() != null) {
            ignoreMigrationPatternsList = this.getEnvironmentOverrides().getIgnoreMigrationPatterns();
        }
        Object[] ignoreMigrationPatterns = (String[])ignoreMigrationPatternsList.toArray(String[]::new);
        if (Arrays.equals(ignoreMigrationPatterns, new String[]{""})) {
            return new ValidatePattern[0];
        }
        return (ValidatePattern[])Arrays.stream(ignoreMigrationPatterns).map(ValidatePattern::fromPattern).toArray(ValidatePattern[]::new);
    }

    public void setIgnoreMigrationPatterns(String ... ignoreMigrationPatterns) {
        this.getModernFlyway().setIgnoreMigrationPatterns(Arrays.stream(ignoreMigrationPatterns).collect(Collectors.toList()));
    }

    public void setIgnoreMigrationPatterns(ValidatePattern ... ignoreMigrationPatterns) {
        this.getModernFlyway().setIgnoreMigrationPatterns(Arrays.stream(ignoreMigrationPatterns).map(ValidatePattern::toString).collect(Collectors.toList()));
    }

    @Override
    public boolean isValidateMigrationNaming() {
        if (this.getEnvironmentOverrides().getValidateMigrationNaming() != null) {
            return this.getEnvironmentOverrides().getValidateMigrationNaming();
        }
        return this.getModernFlyway().getValidateMigrationNaming();
    }

    public void setValidateMigrationNaming(Boolean validateMigrationNamingProp) {
        this.getModernFlyway().setValidateMigrationNaming(validateMigrationNamingProp);
    }

    @Override
    public boolean isValidateOnMigrate() {
        if (this.getEnvironmentOverrides().getValidateOnMigrate() != null) {
            return this.getEnvironmentOverrides().getValidateOnMigrate();
        }
        return this.getModernFlyway().getValidateOnMigrate();
    }

    public void setValidateOnMigrate(Boolean validateOnMigrateProp) {
        this.getModernFlyway().setValidateOnMigrate(validateOnMigrateProp);
    }

    @Override
    public boolean isCleanOnValidationError() {
        if (this.getEnvironmentOverrides().getCleanOnValidationError() != null) {
            return this.getEnvironmentOverrides().getCleanOnValidationError();
        }
        return this.getModernFlyway().getCleanOnValidationError();
    }

    public void setCleanOnValidationError(Boolean cleanOnValidationErrorProp) {
        this.getModernFlyway().setCleanOnValidationError(cleanOnValidationErrorProp);
    }

    @Override
    public boolean isCleanDisabled() {
        if (this.getEnvironmentOverrides().getCleanDisabled() != null) {
            return this.getEnvironmentOverrides().getCleanDisabled();
        }
        return this.getModernFlyway().getCleanDisabled();
    }

    public void setCleanDisabled(Boolean cleanDisabledProp) {
        this.getModernFlyway().setCleanDisabled(cleanDisabledProp);
    }

    @Override
    public boolean isCommunityDBSupportEnabled() {
        if (this.getEnvironmentOverrides().getCommunityDBSupportEnabled() != null) {
            return this.getEnvironmentOverrides().getCommunityDBSupportEnabled();
        }
        return this.getModernFlyway().getCommunityDBSupportEnabled();
    }

    public void setCommunityDBSupportEnabled(Boolean communityDBSupportEnabled) {
        this.getModernFlyway().setCommunityDBSupportEnabled(communityDBSupportEnabled);
    }

    @Override
    public boolean isMixed() {
        if (this.getEnvironmentOverrides().getMixed() != null) {
            return this.getEnvironmentOverrides().getMixed();
        }
        return this.getModernFlyway().getMixed();
    }

    public void setMixed(Boolean mixedProp) {
        this.getModernFlyway().setMixed(mixedProp);
    }

    @Override
    public boolean isGroup() {
        if (this.getEnvironmentOverrides().getGroup() != null) {
            return this.getEnvironmentOverrides().getGroup();
        }
        return this.getModernFlyway().getGroup();
    }

    public void setGroup(Boolean groupProp) {
        this.getModernFlyway().setGroup(groupProp);
    }

    @Override
    public String getInstalledBy() {
        if (this.getEnvironmentOverrides().getInstalledBy() != null) {
            return this.getEnvironmentOverrides().getInstalledBy();
        }
        return this.getModernFlyway().getInstalledBy();
    }

    public void setInstalledBy(String installedBy) {
        if ("".equals(installedBy)) {
            installedBy = null;
        }
        this.getModernFlyway().setInstalledBy(installedBy);
    }

    @Override
    public String[] getErrorOverrides() {
        if (this.getEnvironmentOverrides().getErrorOverrides() != null) {
            return (String[])this.getEnvironmentOverrides().getErrorOverrides().toArray(String[]::new);
        }
        return (String[])this.getModernFlyway().getErrorOverrides().toArray(String[]::new);
    }

    public void setErrorOverrides(String ... errorOverrides) {
        throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier(this), "errorOverrides");
    }

    @Override
    public OutputStream getDryRunOutput() {
        if (this.dryRunOutput == null) {
            String dryRunOutputFileName;
            String string = dryRunOutputFileName = this.getEnvironmentOverrides().getDryRunOutput() != null ? this.getEnvironmentOverrides().getDryRunOutput() : this.getModernFlyway().getDryRunOutput();
            if (!StringUtils.hasText(dryRunOutputFileName)) {
                return null;
            }
        }
        return this.dryRunOutput;
    }

    public void setDryRunOutput(OutputStream dryRunOutput) {
        throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier(this), "dryRunOutput");
    }

    @Override
    public boolean isStream() {
        return this.getEnvironmentOverrides().getStream() != null ? this.getEnvironmentOverrides().getStream() : this.getModernFlyway().getStream();
    }

    public void setStream(boolean stream) {
        this.getModernFlyway().setStream(stream);
    }

    @Override
    public boolean isBatch() {
        return this.getEnvironmentOverrides().getBatch() != null ? this.getEnvironmentOverrides().getBatch() : this.getModernFlyway().getBatch();
    }

    public void setBatch(boolean batch) {
        this.getModernFlyway().setBatch(batch);
    }

    @Override
    public String getKerberosConfigFile() {
        return this.getEnvironmentOverrides().getKerberosConfigFile() != null ? this.getEnvironmentOverrides().getKerberosConfigFile() : this.getModernFlyway().getKerberosConfigFile();
    }

    public void setKerberosConfigFile(String kerberosConfigFile) {
        throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier(this), "kerberosConfigFile");
    }

    @Override
    public boolean isOutputQueryResults() {
        return this.getEnvironmentOverrides().getOutputQueryResults() != null ? this.getEnvironmentOverrides().getOutputQueryResults() : this.getModernFlyway().getOutputQueryResults();
    }

    public void setOutputQueryResults(boolean outputQueryResults) {
        this.getModernFlyway().setOutputQueryResults(outputQueryResults);
    }

    @Override
    public boolean isCreateSchemas() {
        return this.getEnvironmentOverrides().getCreateSchemas() != null ? this.getEnvironmentOverrides().getCreateSchemas() : this.getModernFlyway().getCreateSchemas();
    }

    @Override
    public int getLockRetryCount() {
        return this.getEnvironmentOverrides().getLockRetryCount() != null ? this.getEnvironmentOverrides().getLockRetryCount() : this.getModernFlyway().getLockRetryCount();
    }

    public void setLockRetryCount(Integer lockRetryCount) {
        this.getModernFlyway().setLockRetryCount(lockRetryCount);
    }

    @Override
    public Map<String, String> getJdbcProperties() {
        return this.getCurrentResolvedEnvironment().getJdbcProperties();
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.getCurrentUnresolvedEnvironment().setJdbcProperties(jdbcProperties);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public boolean isFailOnMissingLocations() {
        return this.getEnvironmentOverrides().getFailOnMissingLocations() != null ? this.getEnvironmentOverrides().getFailOnMissingLocations() : this.getModernFlyway().getFailOnMissingLocations();
    }

    public void setFailOnMissingLocations(Boolean failOnMissingLocationsProp) {
        this.getModernFlyway().setFailOnMissingLocations(failOnMissingLocationsProp);
    }

    @Override
    public String[] getLoggers() {
        return this.getEnvironmentOverrides().getLoggers() != null ? (String[])this.getEnvironmentOverrides().getLoggers().toArray(String[]::new) : (String[])this.getModernFlyway().getLoggers().toArray(String[]::new);
    }

    public void setLoggers(String ... loggers) {
        this.getModernFlyway().setLoggers(Arrays.stream(loggers).collect(Collectors.toList()));
    }

    @Override
    public int getConnectRetries() {
        Integer connectionRetries = this.getCurrentResolvedEnvironment().getConnectRetries();
        return connectionRetries != null ? connectionRetries : 0;
    }

    public void setConnectRetries(int connectRetries) {
        if (connectRetries < 0) {
            throw new FlywayException("Invalid number of connectRetries (must be 0 or greater): " + connectRetries, CoreErrorCode.CONFIGURATION);
        }
        this.getCurrentUnresolvedEnvironment().setConnectRetries(connectRetries);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public int getConnectRetriesInterval() {
        Integer connectionRetriesInterval = this.getCurrentResolvedEnvironment().getConnectRetriesInterval();
        return connectionRetriesInterval != null ? connectionRetriesInterval : 120;
    }

    public void setConnectRetriesInterval(int connectRetriesInterval) {
        if (connectRetriesInterval < 0) {
            throw new FlywayException("Invalid number for connectRetriesInterval (must be 0 or greater): " + connectRetriesInterval, CoreErrorCode.CONFIGURATION);
        }
        this.getCurrentUnresolvedEnvironment().setConnectRetriesInterval(connectRetriesInterval);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public String getInitSql() {
        return this.getCurrentResolvedEnvironment().getInitSql();
    }

    public void setInitSql(String initSqlProp) {
        this.getCurrentUnresolvedEnvironment().setInitSql(initSqlProp);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    @Override
    public MigrationVersion getBaselineVersion() {
        String baselineVersion = this.getEnvironmentOverrides().getBaselineVersion() != null ? this.getEnvironmentOverrides().getBaselineVersion() : this.getModernFlyway().getBaselineVersion();
        return MigrationVersion.fromVersion(baselineVersion != null ? baselineVersion : "1");
    }

    public void setBaselineVersion(String baselineVersionProp) {
        this.getModernFlyway().setBaselineVersion(baselineVersionProp);
    }

    public void setBaselineVersion(MigrationVersion baselineVersion) {
        this.getModernFlyway().setBaselineVersion(baselineVersion.getVersion());
    }

    @Override
    public String getBaselineDescription() {
        return this.getEnvironmentOverrides().getBaselineDescription() != null ? this.getEnvironmentOverrides().getBaselineDescription() : this.getModernFlyway().getBaselineDescription();
    }

    public void setBaselineDescription(String baselineDescriptionProp) {
        this.getModernFlyway().setBaselineDescription(baselineDescriptionProp);
    }

    @Override
    public boolean isSkipDefaultResolvers() {
        return this.getEnvironmentOverrides().getSkipDefaultResolvers() != null ? this.getEnvironmentOverrides().getSkipDefaultResolvers() : this.getModernFlyway().getSkipDefaultResolvers();
    }

    public void setSkipDefaultResolvers(Boolean skipDefaultResolversProp) {
        this.getModernFlyway().setSkipDefaultResolvers(skipDefaultResolversProp);
    }

    @Override
    public boolean isSkipDefaultCallbacks() {
        return this.getEnvironmentOverrides().getSkipDefaultCallbacks() != null ? this.getEnvironmentOverrides().getSkipDefaultCallbacks() : this.getModernFlyway().getSkipDefaultCallbacks();
    }

    public void setSkipDefaultCallbacks(Boolean skipDefaultCallbacksProp) {
        this.getModernFlyway().setSkipDefaultCallbacks(skipDefaultCallbacksProp);
    }

    @Override
    public String getSqlMigrationPrefix() {
        return this.getEnvironmentOverrides().getSqlMigrationPrefix() != null ? this.getEnvironmentOverrides().getSqlMigrationPrefix() : this.getModernFlyway().getSqlMigrationPrefix();
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.getModernFlyway().setSqlMigrationPrefix(sqlMigrationPrefix);
    }

    @Override
    public boolean isExecuteInTransaction() {
        return this.getEnvironmentOverrides().getExecuteInTransaction() != null ? this.getEnvironmentOverrides().getExecuteInTransaction() : this.getModernFlyway().getExecuteInTransaction();
    }

    public void setExecuteInTransaction(boolean executeInTransaction) {
        this.getModernFlyway().setExecuteInTransaction(executeInTransaction);
    }

    @Override
    public String getRepeatableSqlMigrationPrefix() {
        return this.getEnvironmentOverrides().getRepeatableSqlMigrationPrefix() != null ? this.getEnvironmentOverrides().getRepeatableSqlMigrationPrefix() : this.getModernFlyway().getRepeatableSqlMigrationPrefix();
    }

    public void setRepeatableSqlMigrationPrefix(String repeatableSqlMigrationPrefixProp) {
        this.getModernFlyway().setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
    }

    @Override
    public String getSqlMigrationSeparator() {
        return this.getEnvironmentOverrides().getSqlMigrationSeparator() != null ? this.getEnvironmentOverrides().getSqlMigrationSeparator() : this.getModernFlyway().getSqlMigrationSeparator();
    }

    public void setSqlMigrationSeparator(String sqlMigrationSeparator) {
        if (!StringUtils.hasLength(sqlMigrationSeparator)) {
            throw new FlywayException("sqlMigrationSeparator cannot be empty!", CoreErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setSqlMigrationSeparator(sqlMigrationSeparator);
    }

    @Override
    public String[] getSqlMigrationSuffixes() {
        return this.getEnvironmentOverrides().getSqlMigrationSuffixes() != null ? (String[])this.getEnvironmentOverrides().getSqlMigrationSuffixes().toArray(String[]::new) : (String[])this.getModernFlyway().getSqlMigrationSuffixes().toArray(String[]::new);
    }

    public void setSqlMigrationSuffixes(String ... sqlMigrationSuffixes) {
        this.getModernFlyway().setSqlMigrationSuffixes(Arrays.stream(sqlMigrationSuffixes).collect(Collectors.toList()));
    }

    @Override
    public boolean isPlaceholderReplacement() {
        return this.getEnvironmentOverrides().getPlaceholderReplacement() != null ? this.getEnvironmentOverrides().getPlaceholderReplacement() : this.getModernFlyway().getPlaceholderReplacement();
    }

    public void setPlaceholderReplacement(Boolean placeholderReplacementProp) {
        this.getModernFlyway().setPlaceholderReplacement(placeholderReplacementProp);
    }

    @Override
    public String getPlaceholderSuffix() {
        return this.getEnvironmentOverrides().getPlaceholderSuffix() != null ? this.getEnvironmentOverrides().getPlaceholderSuffix() : this.getModernFlyway().getPlaceholderSuffix();
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        if (!StringUtils.hasLength(placeholderSuffix)) {
            throw new FlywayException("placeholderSuffix cannot be empty!", CoreErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setPlaceholderSuffix(placeholderSuffix);
    }

    @Override
    public String getPlaceholderPrefix() {
        return this.getEnvironmentOverrides().getPlaceholderPrefix() != null ? this.getEnvironmentOverrides().getPlaceholderPrefix() : this.getModernFlyway().getPlaceholderPrefix();
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        if (!StringUtils.hasLength(placeholderPrefix)) {
            throw new FlywayException("placeholderPrefix cannot be empty!", CoreErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setPlaceholderPrefix(placeholderPrefix);
    }

    @Override
    public String getPlaceholderSeparator() {
        return this.getEnvironmentOverrides().getPlaceholderSeparator() != null ? this.getEnvironmentOverrides().getPlaceholderSeparator() : this.getModernFlyway().getPlaceholderSeparator();
    }

    public void setPlaceholderSeparator(String placeholderSeparator) {
        if (!StringUtils.hasLength(placeholderSeparator)) {
            throw new FlywayException("placeholderSeparator cannot be empty!", CoreErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setPlaceholderSeparator(placeholderSeparator);
    }

    @Override
    public String getScriptPlaceholderSuffix() {
        return this.getEnvironmentOverrides().getScriptPlaceholderSuffix() != null ? this.getEnvironmentOverrides().getScriptPlaceholderSuffix() : this.getModernFlyway().getScriptPlaceholderSuffix();
    }

    public void setScriptPlaceholderSuffix(String scriptPlaceholderSuffix) {
        if (!StringUtils.hasLength(scriptPlaceholderSuffix)) {
            throw new FlywayException("scriptPlaceholderSuffix cannot be empty!", CoreErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setScriptPlaceholderSuffix(scriptPlaceholderSuffix);
    }

    @Override
    public String getScriptPlaceholderPrefix() {
        return this.getEnvironmentOverrides().getScriptPlaceholderPrefix() != null ? this.getEnvironmentOverrides().getScriptPlaceholderPrefix() : this.getModernFlyway().getScriptPlaceholderPrefix();
    }

    public void setScriptPlaceholderPrefix(String scriptPlaceholderPrefix) {
        if (!StringUtils.hasLength(scriptPlaceholderPrefix)) {
            throw new FlywayException("scriptPlaceholderPrefix cannot be empty!", CoreErrorCode.CONFIGURATION);
        }
        this.getModernFlyway().setScriptPlaceholderPrefix(scriptPlaceholderPrefix);
    }

    @Override
    public String getPowershellExecutable() {
        return this.getEnvironmentOverrides().getPowershellExecutable() != null ? this.getEnvironmentOverrides().getPowershellExecutable() : this.getModernFlyway().getPowershellExecutable();
    }

    public void setPowershellExecutable(String powershellExecutable) {
        this.getModernFlyway().setPowershellExecutable(powershellExecutable);
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return this.getEnvironmentOverrides().getPlaceholders() != null ? this.getEnvironmentOverrides().getPlaceholders() : this.getModernFlyway().getPlaceholders();
    }

    public void setPlaceholders(Map<String, String> placeholdersFromProps) {
        this.getModernFlyway().setPlaceholders(placeholdersFromProps);
    }

    @Override
    public MigrationVersion getTarget() {
        String target;
        String string = target = this.getEnvironmentOverrides().getTarget() != null ? this.getEnvironmentOverrides().getTarget() : this.getModernFlyway().getTarget();
        if (target.endsWith("?")) {
            this.getModernFlyway().setFailOnMissingTarget(false);
            return MigrationVersion.fromVersion(target.substring(0, target.length() - 1));
        }
        this.getModernFlyway().setFailOnMissingTarget(true);
        return MigrationVersion.fromVersion(target);
    }

    public void setTarget(MigrationVersion target) {
        if (target != null) {
            this.getModernFlyway().setTarget(target.getName());
        } else {
            this.getModernFlyway().setTarget("latest");
        }
    }

    @Override
    public boolean isFailOnMissingTarget() {
        return this.getEnvironmentOverrides().getFailOnMissingTarget() != null ? this.getEnvironmentOverrides().getFailOnMissingTarget() : this.getModernFlyway().getFailOnMissingTarget();
    }

    @Override
    public MigrationPattern[] getCherryPick() {
        CherryPickConfiguration patternsStub = this.pluginRegister.getInstanceOf(CherryPickConfiguration.class);
        if (patternsStub == null) {
            LOG.debug("CherryPickConfigurationExtension not found");
            return null;
        }
        return patternsStub.getMigrationPatterns(this);
    }

    @Override
    public String getTable() {
        return this.getEnvironmentOverrides().getTable() != null ? this.getEnvironmentOverrides().getTable() : this.getModernFlyway().getTable();
    }

    public void setTable(String tableProp) {
        this.getModernFlyway().setTable(tableProp);
    }

    @Override
    public String getTablespace() {
        return this.getEnvironmentOverrides().getTablespace() != null ? this.getEnvironmentOverrides().getTablespace() : this.getModernFlyway().getTablespace();
    }

    public void setTablespace(String tablespaceProp) {
        this.getModernFlyway().setTablespace(tablespaceProp);
    }

    public void setDryRunOutputAsFile(File dryRunOutput) {
        throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier(this), "dryRunOutput");
    }

    public void setDryRunOutputAsFileName(String dryRunOutputFileName) {
        throw new FlywayEditionUpgradeRequiredException(LicenseGuard.getTier(this), "dryRunOutput");
    }

    public void setLocationsAsStrings(String ... locations) {
        this.getModernFlyway().setLocations(Arrays.stream(locations).collect(Collectors.toList()));
    }

    public void setCallbackLocationsAsStrings(String ... callbackLocations) {
        this.getModernFlyway().setCallbackLocations(Arrays.stream(callbackLocations).collect(Collectors.toList()));
    }

    public void setEnvironment(String environment) {
        if (!this.modernConfig.getEnvironments().containsKey(environment)) {
            throw new FlywayException("Environment '" + environment + "' not found");
        }
        this.getModernFlyway().setEnvironment(environment);
    }

    public void setProvisionMode(ProvisionerMode provisionerMode) {
        this.getModernFlyway().setProvisionMode(provisionerMode.getValue());
    }

    public void setEnvironmentProvisionMode(ProvisionerMode provisionMode) {
        this.setProvisionMode(provisionMode);
    }

    public void setAllEnvironments(Map<String, EnvironmentModel> environments) {
        this.modernConfig.setEnvironments(environments);
        this.resolvedEnvironments.clear();
    }

    public void setEncodingAsString(String encoding) {
        this.getModernFlyway().setEncoding(encoding);
    }

    public void setTargetAsString(String target) {
        this.getModernFlyway().setTarget(target);
    }

    public void setJavaMigrations(JavaMigration ... javaMigrations) {
        if (javaMigrations == null) {
            throw new FlywayException("javaMigrations cannot be null", CoreErrorCode.CONFIGURATION);
        }
        this.javaMigrations = javaMigrations;
    }

    public void setDataSource(String url, String user, String password) {
        this.getCurrentUnresolvedEnvironment().setUrl(url);
        this.getCurrentUnresolvedEnvironment().setUser(user);
        this.getCurrentUnresolvedEnvironment().setPassword(password);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
        if (NativeConnectorsModeUtils.canCreateDataSource(this)) {
            this.dataSources.put(this.getCurrentEnvironmentName(), new DataSourceModel(new DriverDataSource(this.classLoader, null, url, user, password, this, this.getCurrentUnresolvedEnvironment().getJdbcProperties()), true));
        }
        this.licenseGuardJdbcUrl(url);
    }

    @Override
    public DatabaseType getDatabaseType() {
        String url = this.getUrl();
        DataSourceModel model = this.dataSources.getOrDefault(this.getCurrentEnvironmentName(), null);
        if (StringUtils.hasText(url)) {
            return DatabaseTypeRegister.getDatabaseTypeForUrl(url, this);
        }
        if (model != null) {
            if (model.getDatabaseType() != null) {
                return model.getDatabaseType();
            }
            if (model.getDataSource() != null) {
                DatabaseType databaseType;
                block12: {
                    Connection connection = model.getDataSource().getConnection();
                    try {
                        DatabaseType databaseType2 = DatabaseTypeRegister.getDatabaseTypeForConnection(connection, this);
                        model.setDatabaseType(databaseType2);
                        databaseType = databaseType2;
                        if (connection == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    connection.close();
                }
                return databaseType;
            }
        }
        return null;
    }

    public void setBaselineVersionAsString(String baselineVersion) {
        this.setBaselineVersion(baselineVersion);
    }

    public void setCallbacksAsClassNames(String ... callbacks) {
        this.getModernFlyway().setCallbacks(Arrays.stream(callbacks).collect(Collectors.toList()));
    }

    private void loadUnloadedCallbacks() {
        List<String> callbacks = this.getEnvironmentOverrides().getCallbacks() != null ? this.getEnvironmentOverrides().getCallbacks() : this.getModernFlyway().getCallbacks();
        for (String callback : callbacks) {
            List<Callback> newCallbacks = this.loadCallbackPath(callback);
            this.callbacks.addAll(newCallbacks.stream().filter(this::callbackNotLoadedYet).toList());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Callback> loadCallbackPath(String callbackPath) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        Object o = null;
        try {
            o = ClassUtils.instantiate(callbackPath, this.classLoader);
        }
        catch (FlywayException flywayException) {
            // empty catch block
        }
        if (o != null) {
            if (!(o instanceof Callback)) throw new FlywayException("Invalid callback: " + callbackPath + " (must implement org.flywaydb.core.api.callback.Callback)", CoreErrorCode.CONFIGURATION);
            callbacks.add(o);
            return callbacks;
        } else {
            callbacks.addAll(this.loadCallbackLocation(callbackPath, true));
        }
        return callbacks;
    }

    private boolean callbackNotLoadedYet(Callback callback) {
        return this.callbacks.stream().noneMatch(c -> c.getClass().getCanonicalName().equals(callback.getClass().getCanonicalName()));
    }

    public List<Callback> loadCallbackLocation(String path, boolean errorOnNotFound) {
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        List<String> callbackClasses = this.classScanner.scanForType(path, Callback.class, errorOnNotFound);
        for (String callback : callbackClasses) {
            Class<Callback> callbackClass;
            try {
                callbackClass = ClassUtils.loadClass(Callback.class, callback, this.classLoader);
            }
            catch (Throwable e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                LOG.warn("Skipping " + String.valueOf(Callback.class) + ": " + ClassUtils.formatThrowable(e) + (String)(rootCause == e ? "" : " caused by " + ClassUtils.formatThrowable(rootCause) + " at " + ExceptionUtils.getThrowLocation(rootCause)));
                callbackClass = null;
            }
            if (callbackClass == null) continue;
            Callback callbackObj = (Callback)ClassUtils.instantiate(callback, this.classLoader);
            callbacks.add(callbackObj);
        }
        return callbacks;
    }

    public void setResolversAsClassNames(String ... resolvers) {
        this.getModernFlyway().setMigrationResolvers(Arrays.stream(resolvers).collect(Collectors.toList()));
    }

    public void setShouldCreateSchemas(boolean createSchemas) {
        this.getModernFlyway().setCreateSchemas(createSchemas);
    }

    public void configure(Configuration configuration) {
        this.modernConfig = ConfigurationModel.clone(configuration.getModernConfig());
        this.workingDirectory = configuration.getWorkingDirectory();
        this.setJavaMigrations(configuration.getJavaMigrations());
        this.resourceProvider = configuration.getResourceProvider();
        this.javaMigrationClassProvider = configuration.getJavaMigrationClassProvider();
        this.setCallbacks(configuration.getCallbacks());
        this.setClassLoader(configuration.getClassLoader());
        this.setResolvers((MigrationResolver[])configuration.getResolvers().clone());
        this.getModernFlyway().setMigrationResolvers(null);
        this.resolvedEnvironments.clear();
        this.resolvedEnvironments.putAll(configuration.getCachedResolvedEnvironments());
        this.dataSources.clear();
        this.dataSources.putAll(configuration.getCachedDataSources());
        this.pluginRegister = configuration.getPluginRegister().getCopy();
        this.configureFromConfigurationProviders(this);
    }

    public void configure(Properties properties) {
        this.configure(ConfigUtils.propertiesToMap(properties));
    }

    private void setJarDirsAsStrings(String ... jarDirs) {
        this.getModernFlyway().setJarDirs(Arrays.stream(jarDirs).collect(Collectors.toList()));
    }

    public void configure(Map<String, String> props) {
        Map<String, String> jdbcPropertiesFromProps;
        Boolean failOnMissingLocationsProp;
        String ignoreMigrationPatternsProp;
        String kerberosConfigFile;
        Boolean createSchemasProp;
        Boolean batchProp;
        Boolean streamProp;
        String errorOverridesProp;
        String dryRunOutputProp;
        String installedByProp;
        Boolean groupProp;
        Boolean skipDefaultCallbacksProp;
        String callbacksProp;
        Boolean skipDefaultResolversProp;
        String resolversProp;
        Boolean outputQueryResultsProp;
        Boolean skipExecutingMigrationsProp;
        Boolean outOfOrderProp;
        Integer lockRetryCount;
        String loggersProp;
        String targetProp;
        Boolean validateMigrationNamingProp;
        Boolean baselineOnMigrateProp;
        String baselineDescriptionProp;
        String baselineVersionProp;
        Boolean validateOnMigrateProp;
        Boolean reportEnabledProp;
        Boolean communityDBSupportEnabledProd;
        Boolean cleanDisabledProp;
        Boolean cleanOnValidationErrorProp;
        String tablespaceProp;
        String tableProp;
        String schemasProp;
        String defaultSchemaProp;
        Boolean executeInTransaction;
        Boolean detectEncoding;
        String encodingProp;
        String sqlMigrationSuffixesProp;
        String sqlMigrationSeparatorProp;
        String repeatableSqlMigrationPrefixProp;
        String sqlMigrationPrefixProp;
        String powershellExecutableProp;
        String scriptPlaceholderSuffixProp;
        String scriptPlaceholderPrefixProp;
        String placeholderSeparatorProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        Boolean placeholderReplacementProp;
        String jarDirsProp;
        String callbackLocationsProp;
        String locationsProp;
        String outputType;
        String initSqlProp;
        Integer connectRetriesIntervalProp;
        Integer connectRetriesProp;
        String passwordProp;
        String outputLogsInJson;
        String outputProgress;
        String userProp;
        String urlProp;
        String driverProp;
        HashMap<String, String> tempProps = new HashMap<String, String>(props);
        for (String key : props.keySet()) {
            if (!key.startsWith("environments.tempConfigEnvironment")) continue;
            tempProps.put(key.replace("environments.tempConfigEnvironment", "flyway"), props.get(key));
        }
        props = new HashMap<String, String>(tempProps);
        props.computeIfAbsent("flyway.reportFilename", k -> this.getModernFlyway().getReportFilename());
        HashMap<String, Map<String, Object>> configExtensionsPropertyMap = new HashMap<String, Map<String, Object>>();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        String deprecatedNameSpace = "plugins";
        LinkedHashSet sortedEntrySet = new LinkedHashSet();
        sortedEntrySet.addAll(props.entrySet().stream().filter(r -> ((String)r.getKey()).contains("plugins")).collect(Collectors.toSet()));
        sortedEntrySet.addAll(props.entrySet().stream().filter(r -> !sortedEntrySet.contains(r)).collect(Collectors.toSet()));
        for (Map.Entry params : sortedEntrySet) {
            String text = (String)params.getKey();
            Matcher matcher = ANY_WORD_BETWEEN_TWO_DOTS_PATTERN.matcher(text);
            String rootNamespace = matcher.find() ? matcher.group(1) : "";
            List<ConfigurationExtension> configExtensions = this.pluginRegister.getInstancesOf(ConfigurationExtension.class).stream().filter(c -> c.getNamespace().isEmpty() || rootNamespace.equals(c.getNamespace()) || rootNamespace.equals("plugins")).toList();
            configExtensions.forEach(c -> {
                if (c.getNamespace().isEmpty()) {
                    String replaceNamespace = "flyway.plugins.";
                    String fixedKey = ((String)params.getKey()).replace("flyway.plugins.", "");
                    ClassicConfiguration.parsePropertiesFromConfigExtension(configExtensionsPropertyMap, keysToRemove, params, fixedKey, c);
                }
            });
            configExtensions.forEach(c -> {
                Object replaceNamespace = "flyway.";
                if (StringUtils.hasText(rootNamespace) && !c.getNamespace().isEmpty()) {
                    replaceNamespace = "flyway." + rootNamespace + ".";
                }
                String fixedKey = ((String)params.getKey()).replace((CharSequence)replaceNamespace, "");
                ClassicConfiguration.parsePropertiesFromConfigExtension(configExtensionsPropertyMap, keysToRemove, params, fixedKey, c);
            });
        }
        this.determineKeysToRemoveAndRemoveFromProps(configExtensionsPropertyMap, keysToRemove, props);
        String reportFilenameProp = props.remove("flyway.reportFilename");
        if (reportFilenameProp != null) {
            this.setReportFilename(reportFilenameProp);
        }
        if ((driverProp = props.remove("flyway.driver")) != null) {
            this.setDriver(driverProp);
        }
        if ((urlProp = props.remove("flyway.url")) != null) {
            this.setUrl(urlProp);
        }
        if ((userProp = props.remove("flyway.user")) != null) {
            this.setUser(userProp);
        }
        if ((outputProgress = props.remove("flyway.outputProgress")) != null) {
            this.getModernFlyway().setOutputProgress(Boolean.parseBoolean(outputProgress));
        }
        if ((outputLogsInJson = props.remove("flyway.outputLogsInJson")) != null) {
            this.getModernFlyway().setOutputLogsInJson(Boolean.parseBoolean(outputLogsInJson));
        }
        if ((passwordProp = props.remove("flyway.password")) != null) {
            this.setPassword(passwordProp);
        }
        if ((connectRetriesProp = ConfigUtils.removeInteger(props, "flyway.connectRetries")) != null) {
            this.setConnectRetries(connectRetriesProp);
        }
        if ((connectRetriesIntervalProp = ConfigUtils.removeInteger(props, "flyway.connectRetriesInterval")) != null) {
            this.setConnectRetriesInterval(connectRetriesIntervalProp);
        }
        if ((initSqlProp = props.remove("flyway.initSql")) != null) {
            this.setInitSql(initSqlProp);
        }
        if ((outputType = props.remove("flyway.outputType")) != null) {
            this.getModernFlyway().setOutputType(outputType);
        }
        if ((locationsProp = props.remove("flyway.locations")) != null) {
            this.setLocationsAsStrings(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((callbackLocationsProp = props.remove("flyway.callbackLocations")) != null) {
            this.setCallbackLocationsAsStrings(StringUtils.tokenizeToStringArray(callbackLocationsProp, ","));
        }
        if ((jarDirsProp = props.remove("flyway.jarDirs")) != null) {
            this.setJarDirsAsStrings(StringUtils.tokenizeToStringArray(jarDirsProp, ","));
        }
        if ((placeholderReplacementProp = ConfigUtils.removeBoolean(props, "flyway.placeholderReplacement")) != null) {
            this.setPlaceholderReplacement(placeholderReplacementProp);
        }
        if ((placeholderPrefixProp = props.remove("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = props.remove("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((placeholderSeparatorProp = props.remove("flyway.placeholderSeparator")) != null) {
            this.setPlaceholderSeparator(placeholderSeparatorProp);
        }
        if ((scriptPlaceholderPrefixProp = props.remove("flyway.scriptPlaceholderPrefix")) != null) {
            this.setScriptPlaceholderPrefix(scriptPlaceholderPrefixProp);
        }
        if ((scriptPlaceholderSuffixProp = props.remove("flyway.scriptPlaceholderSuffix")) != null) {
            this.setScriptPlaceholderSuffix(scriptPlaceholderSuffixProp);
        }
        if ((powershellExecutableProp = props.remove("flyway.powershellExecutable")) != null) {
            this.setPowershellExecutable(powershellExecutableProp);
        }
        if ((sqlMigrationPrefixProp = props.remove("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((repeatableSqlMigrationPrefixProp = props.remove("flyway.repeatableSqlMigrationPrefix")) != null) {
            this.setRepeatableSqlMigrationPrefix(repeatableSqlMigrationPrefixProp);
        }
        if ((sqlMigrationSeparatorProp = props.remove("flyway.sqlMigrationSeparator")) != null) {
            this.setSqlMigrationSeparator(sqlMigrationSeparatorProp);
        }
        if ((sqlMigrationSuffixesProp = props.remove("flyway.sqlMigrationSuffixes")) != null) {
            this.setSqlMigrationSuffixes(StringUtils.tokenizeToStringArray(sqlMigrationSuffixesProp, ","));
        }
        if ((encodingProp = props.remove("flyway.encoding")) != null) {
            this.setEncodingAsString(encodingProp);
        }
        if ((detectEncoding = ConfigUtils.removeBoolean(props, "flyway.detectEncoding")) != null) {
            this.setDetectEncoding(detectEncoding);
        }
        if ((executeInTransaction = ConfigUtils.removeBoolean(props, "flyway.executeInTransaction")) != null) {
            this.setExecuteInTransaction(executeInTransaction);
        }
        if ((defaultSchemaProp = props.remove("flyway.defaultSchema")) != null) {
            this.setDefaultSchema(defaultSchemaProp);
        }
        if ((schemasProp = props.remove("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = props.remove("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((tablespaceProp = props.remove("flyway.tablespace")) != null) {
            this.setTablespace(tablespaceProp);
        }
        if ((cleanOnValidationErrorProp = ConfigUtils.removeBoolean(props, "flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(cleanOnValidationErrorProp);
        }
        if ((cleanDisabledProp = ConfigUtils.removeBoolean(props, "flyway.cleanDisabled")) != null) {
            this.setCleanDisabled(cleanDisabledProp);
        }
        if ((communityDBSupportEnabledProd = ConfigUtils.removeBoolean(props, "flyway.communityDBSupportEnabled")) != null) {
            this.setCommunityDBSupportEnabled(communityDBSupportEnabledProd);
        }
        if ((reportEnabledProp = ConfigUtils.removeBoolean(props, "flyway.reportEnabled")) != null) {
            this.setReportEnabled(reportEnabledProp);
        }
        if ((validateOnMigrateProp = ConfigUtils.removeBoolean(props, "flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(validateOnMigrateProp);
        }
        if ((baselineVersionProp = props.remove("flyway.baselineVersion")) != null) {
            this.setBaselineVersion(baselineVersionProp);
        }
        if ((baselineDescriptionProp = props.remove("flyway.baselineDescription")) != null) {
            this.setBaselineDescription(baselineDescriptionProp);
        }
        if ((baselineOnMigrateProp = ConfigUtils.removeBoolean(props, "flyway.baselineOnMigrate")) != null) {
            this.setBaselineOnMigrate(baselineOnMigrateProp);
        }
        if ((validateMigrationNamingProp = ConfigUtils.removeBoolean(props, "flyway.validateMigrationNaming")) != null) {
            this.setValidateMigrationNaming(validateMigrationNamingProp);
        }
        if ((targetProp = props.remove("flyway.target")) != null) {
            this.setTargetAsString(targetProp);
        }
        if ((loggersProp = props.remove("flyway.loggers")) != null) {
            this.setLoggers(StringUtils.tokenizeToStringArray(loggersProp, ","));
        }
        if ((lockRetryCount = ConfigUtils.removeInteger(props, "flyway.lockRetryCount")) != null) {
            this.setLockRetryCount(lockRetryCount);
        }
        if ((outOfOrderProp = ConfigUtils.removeBoolean(props, "flyway.outOfOrder")) != null) {
            this.setOutOfOrder(outOfOrderProp);
        }
        if ((skipExecutingMigrationsProp = ConfigUtils.removeBoolean(props, "flyway.skipExecutingMigrations")) != null) {
            this.setSkipExecutingMigrations(skipExecutingMigrationsProp);
        }
        if ((outputQueryResultsProp = ConfigUtils.removeBoolean(props, "flyway.outputQueryResults")) != null) {
            this.setOutputQueryResults(outputQueryResultsProp);
        }
        if (StringUtils.hasLength(resolversProp = props.remove("flyway.resolvers"))) {
            this.setResolversAsClassNames(StringUtils.tokenizeToStringArray(resolversProp, ","));
        }
        if ((skipDefaultResolversProp = ConfigUtils.removeBoolean(props, "flyway.skipDefaultResolvers")) != null) {
            this.setSkipDefaultResolvers(skipDefaultResolversProp);
        }
        if (StringUtils.hasLength(callbacksProp = props.remove("flyway.callbacks"))) {
            this.setCallbacksAsClassNames(StringUtils.tokenizeToStringArray(callbacksProp, ","));
        }
        if ((skipDefaultCallbacksProp = ConfigUtils.removeBoolean(props, "flyway.skipDefaultCallbacks")) != null) {
            this.setSkipDefaultCallbacks(skipDefaultCallbacksProp);
        }
        Map<String, String> placeholdersFromProps = this.getPropertiesUnderNamespace(props, this.getPlaceholders(), "flyway.placeholders.");
        this.setPlaceholders(placeholdersFromProps);
        Boolean mixedProp = ConfigUtils.removeBoolean(props, "flyway.mixed");
        if (mixedProp != null) {
            this.setMixed(mixedProp);
        }
        if ((groupProp = ConfigUtils.removeBoolean(props, "flyway.group")) != null) {
            this.setGroup(groupProp);
        }
        if ((installedByProp = props.remove("flyway.installedBy")) != null) {
            this.setInstalledBy(installedByProp);
        }
        if ((dryRunOutputProp = props.remove("flyway.dryRunOutput")) != null) {
            this.setDryRunOutputAsFileName(dryRunOutputProp);
        }
        if ((errorOverridesProp = props.remove("flyway.errorOverrides")) != null) {
            this.setErrorOverrides(StringUtils.tokenizeToStringArray(errorOverridesProp, ","));
        }
        if ((streamProp = ConfigUtils.removeBoolean(props, "flyway.stream")) != null) {
            this.setStream(streamProp);
        }
        if ((batchProp = ConfigUtils.removeBoolean(props, "flyway.batch")) != null) {
            this.setBatch(batchProp);
        }
        if ((createSchemasProp = ConfigUtils.removeBoolean(props, "flyway.createSchemas")) != null) {
            this.setShouldCreateSchemas(createSchemasProp);
        }
        if ((kerberosConfigFile = props.remove("flyway.kerberosConfigFile")) != null) {
            this.setKerberosConfigFile(kerberosConfigFile);
        }
        if ((ignoreMigrationPatternsProp = props.remove("flyway.ignoreMigrationPatterns")) != null) {
            this.setIgnoreMigrationPatterns(StringUtils.tokenizeToStringArray(ignoreMigrationPatternsProp, ","));
        }
        if ((failOnMissingLocationsProp = ConfigUtils.removeBoolean(props, "flyway.failOnMissingLocations")) != null) {
            this.setFailOnMissingLocations(failOnMissingLocationsProp);
        }
        if (!(jdbcPropertiesFromProps = this.getPropertiesUnderNamespace(props, this.getJdbcProperties(), "flyway.jdbcProperties.")).isEmpty()) {
            this.setJdbcProperties(jdbcPropertiesFromProps);
        }
        if (this.getDataSource() == null || Stream.of(urlProp, driverProp, userProp, passwordProp).anyMatch(StringUtils::hasText)) {
            String environmentName = this.getCurrentEnvironmentName();
            if (this.resolvedEnvironments.containsKey(environmentName) && !this.resolvedEnvironmentMatchesClassicConfig(this.resolvedEnvironments.get(environmentName))) {
                this.requestResolvedEnvironmentRefresh(environmentName);
            }
            if (Stream.of(urlProp, driverProp, userProp, passwordProp).anyMatch(StringUtils::hasText)) {
                DriverDataSource driverDataSource = null;
                boolean isGenerated = false;
                if (StringUtils.hasText(urlProp) && NativeConnectorsModeUtils.canCreateDataSource(this)) {
                    driverDataSource = new DriverDataSource(this.classLoader, this.getDriver(), this.getUrl(), this.getUser(), this.getPassword(), this, this.getJdbcProperties());
                    isGenerated = true;
                }
                this.dataSources.put(environmentName, new DataSourceModel(driverDataSource, isGenerated));
            }
        }
        ConfigUtils.checkConfigurationForUnrecognisedProperties(props, "flyway.");
    }

    @Override
    public String getDriver() {
        return this.getCurrentResolvedEnvironment().getDriver();
    }

    public void setDriver(String driver) {
        this.getCurrentUnresolvedEnvironment().setDriver(driver);
        this.requestResolvedEnvironmentRefresh(this.getCurrentEnvironmentName());
    }

    public void requestResolvedEnvironmentRefresh(String environmentName) {
        this.resolvedEnvironments.remove(environmentName);
        DataSourceModel model = this.dataSources.get(environmentName);
        if (model != null && model.isDataSourceGenerated()) {
            this.dataSources.remove(environmentName);
        }
    }

    private boolean resolvedEnvironmentMatchesClassicConfig(ResolvedEnvironment environment) {
        return Objects.equals(this.getUrl(), environment.getUrl()) && Objects.equals(this.getUser(), environment.getUser()) && Objects.equals(this.getPassword(), environment.getPassword());
    }

    @Override
    public String getCurrentEnvironmentName() {
        String envName = this.getModernFlyway().getEnvironment();
        if (!StringUtils.hasText(envName)) {
            envName = "default";
        }
        if (!this.modernConfig.getEnvironments().containsKey(envName) && !"-".equals(envName)) {
            throw new FlywayException("Environment '" + envName + "' not found. Check that this environment exists in your configuration.");
        }
        return envName;
    }

    private EnvironmentModel getCurrentUnresolvedEnvironment() {
        return this.modernConfig.getEnvironments().getOrDefault(this.getCurrentEnvironmentName(), new EnvironmentModel());
    }

    private void licenseGuardJdbcUrl(String url) {
        if (!url.toLowerCase(Locale.ROOT).startsWith("jdbc-secretsmanager:")) {
            return;
        }
    }

    private void determineKeysToRemoveAndRemoveFromProps(Map<String, Map<String, Object>> configExtensionsPropertyMap, Collection<String> keysToRemove, Map<String, String> props) {
        for (Map.Entry<String, Map<String, Object>> property : configExtensionsPropertyMap.entrySet()) {
            ConfigurationExtension cfg = this.pluginRegister.getInstancesOf(ConfigurationExtension.class).stream().filter(c -> c.getClass().toString().equals(property.getKey())).findFirst().orElse(null);
            if (cfg == null) continue;
            Map<String, Object> mpTmp = property.getValue();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                HashMap<String, String[]> mp = new HashMap<String, String[]>();
                for (Map.Entry<String, Object> entry : mpTmp.entrySet()) {
                    Field[] subFields = cfg.getClass().getDeclaredFields();
                    Field field = Arrays.stream(subFields).filter(f -> f.getName().equals(entry.getKey())).findFirst().orElse(null);
                    Object value = field.getType() == List.class || field.getType() == String[].class ? ((String)entry.getValue()).split(",") : entry.getValue();
                    mp.put(entry.getKey(), (String[])value);
                }
                ConfigurationExtension newConfigurationExtension = (ConfigurationExtension)objectMapper.convertValue(mp, cfg.getClass());
                MergeUtils.mergeModel(newConfigurationExtension, cfg);
            }
            catch (Exception e) {
                Matcher matcher = ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN.matcher(e.getMessage());
                if (!matcher.find()) continue;
                String errorProperty = matcher.group(1);
                List<String> propsToRemove = keysToRemove.stream().filter(k -> k.endsWith(errorProperty)).toList();
                keysToRemove.removeAll(propsToRemove);
            }
        }
        props.keySet().removeAll(keysToRemove);
    }

    private void configureFromConfigurationProviders(ClassicConfiguration configuration) {
        HashMap<String, String> config = new HashMap<String, String>();
        for (ConfigurationProvider configurationProvider : this.pluginRegister.getInstancesOf(ConfigurationProvider.class)) {
            ConfigurationExtension configurationExtension = (ConfigurationExtension)this.pluginRegister.getExact(configurationProvider.getConfigurationExtensionClass());
            try {
                config.putAll(configurationProvider.getConfiguration(configurationExtension, configuration));
            }
            catch (Exception e) {
                throw new FlywayException("Unable to read configuration from " + configurationProvider.getClass().getName() + ": " + e.getMessage());
            }
        }
        this.configure(config);
    }

    private Map<String, String> getPropertiesUnderNamespace(Map<String, String> properties, Map<String, String> current, String namespace) {
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String propertyName = entry.getKey();
            if (!propertyName.startsWith(namespace) || propertyName.length() <= namespace.length()) continue;
            String placeholderName = propertyName.substring(namespace.length());
            String placeholderValue = entry.getValue();
            current.put(placeholderName, placeholderValue);
            iterator.remove();
        }
        return current;
    }

    public void configureUsingEnvVars() {
        this.configure(ConfigUtils.environmentVariablesToPropertyMap());
    }

    @Override
    public ProgressLogger createProgress(String operationName) {
        if (this.getModernFlyway().getOutputProgress().booleanValue() && "json".equalsIgnoreCase(this.getModernFlyway().getOutputType())) {
            return new ProgressLoggerJson(operationName);
        }
        return new ProgressLoggerEmpty();
    }

    @Override
    public <T extends ConfigurationExtension> T getConfigurationExtension(Class<T> extensionClass) {
        return (T)((ConfigurationExtension)this.pluginRegister.getExact(extensionClass));
    }

    @Override
    public ConfigurationModel getModernConfig() {
        return this.modernConfig;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @Override
    public ClassProvider<JavaMigration> getJavaMigrationClassProvider() {
        return this.javaMigrationClassProvider;
    }

    @Override
    public JavaMigration[] getJavaMigrations() {
        return this.javaMigrations;
    }

    @Override
    public PluginRegister getPluginRegister() {
        return this.pluginRegister;
    }

    public List<String> getJarDirs() {
        if (this.getEnvironmentOverrides().getJarDirs() != null) {
            return this.getEnvironmentOverrides().getJarDirs();
        }
        return this.getModernFlyway().getJarDirs();
    }

    @Generated
    public void setModernConfig(ConfigurationModel modernConfig) {
        this.modernConfig = modernConfig;
    }

    @Generated
    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Generated
    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    @Generated
    public void setJavaMigrationClassProvider(ClassProvider<JavaMigration> javaMigrationClassProvider) {
        this.javaMigrationClassProvider = javaMigrationClassProvider;
    }

    @Generated
    public void setPluginRegister(PluginRegister pluginRegister) {
        this.pluginRegister = pluginRegister;
    }
}

