/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.time.TimeProvider;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;

public class GranularZonedDateTime {
    public final ZonedDateTime zdt;
    public final ChronoField precision;

    public static GranularZonedDateTime of(Date date, ChronoField precision) {
        return GranularZonedDateTime.of(date, precision, ZoneId.systemDefault());
    }

    public static GranularZonedDateTime of(Date date, ChronoField precision, ZoneId zoneId) {
        return GranularZonedDateTime.of(date.toInstant().atZone(zoneId), precision);
    }

    public static GranularZonedDateTime of(String value) {
        return GranularZonedDateTime.of(value, null, null);
    }

    public static GranularZonedDateTime of(String value, TimeProvider timeProvider) {
        return GranularZonedDateTime.of(value, null, timeProvider);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GranularZonedDateTime of(String value, ZoneId defaultZoneId, TimeProvider timeProvider) {
        AssertionUtils.assertArgNotNull("value", value);
        AsciiSet digit = StringUtils.DIGIT;
        timeProvider = timeProvider == null ? TimeProvider.INSTANCE : timeProvider;
        int year = 1;
        int month = 1;
        int day = 1;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int nanos = 0;
        int ohour = -1;
        int ominute = -1;
        boolean nego = false;
        boolean timeOnly = false;
        ZoneId zoneId = null;
        StateEnum state = StateEnum.S1;
        int mark = 0;
        ChronoField precision = ChronoField.YEAR;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (state == StateEnum.S1) {
                if (digit.contains(c)) {
                    mark = i;
                    state = StateEnum.S2;
                    continue;
                }
                if (c != 'T') throw GranularZonedDateTime.bad(value, i);
                timeOnly = true;
                state = StateEnum.S7;
                continue;
            }
            if (state == StateEnum.S2) {
                if (digit.contains(c)) continue;
                if (c == '-') {
                    year = GranularZonedDateTime.parse(value, 4, mark, i, 0, 9999);
                    state = StateEnum.S3;
                    continue;
                }
                if (c == 'T') {
                    year = GranularZonedDateTime.parse(value, 4, mark, i, 0, 9999);
                    state = StateEnum.S7;
                    continue;
                }
                if (c == 'Z') {
                    zoneId = ZoneId.of("Z");
                    year = GranularZonedDateTime.parse(value, 4, mark, i, 0, 9999);
                    state = StateEnum.S15;
                    continue;
                }
                if (c != '+') throw GranularZonedDateTime.bad(value, i);
                year = GranularZonedDateTime.parse(value, 4, mark, i, 0, 9999);
                nego = false;
                state = StateEnum.S16;
                continue;
            }
            if (state == StateEnum.S3) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S4;
                precision = ChronoField.MONTH_OF_YEAR;
                continue;
            }
            if (state == StateEnum.S4) {
                if (digit.contains(c)) continue;
                if (c == '-') {
                    month = GranularZonedDateTime.parse(value, 2, mark, i, 1, 12);
                    state = StateEnum.S5;
                    continue;
                }
                if (c == 'T') {
                    month = GranularZonedDateTime.parse(value, 2, mark, i, 1, 12);
                    state = StateEnum.S7;
                    continue;
                }
                if (c == 'Z') {
                    month = GranularZonedDateTime.parse(value, 2, mark, i, 1, 12);
                    zoneId = ZoneId.of("Z");
                    state = StateEnum.S15;
                    continue;
                }
                if (c != '+') throw GranularZonedDateTime.bad(value, i);
                month = GranularZonedDateTime.parse(value, 2, mark, i, 1, 12);
                nego = false;
                state = StateEnum.S16;
                continue;
            }
            if (state == StateEnum.S5) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S6;
                precision = ChronoField.DAY_OF_MONTH;
                continue;
            }
            if (state == StateEnum.S6) {
                if (digit.contains(c)) continue;
                if (c == 'T') {
                    day = GranularZonedDateTime.parse(value, 2, mark, i, 1, 31);
                    state = StateEnum.S7;
                    continue;
                }
                if (c == 'Z') {
                    day = GranularZonedDateTime.parse(value, 2, mark, i, 1, 31);
                    zoneId = ZoneId.of("Z");
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    day = GranularZonedDateTime.parse(value, 2, mark, i, 1, 31);
                    nego = false;
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                day = GranularZonedDateTime.parse(value, 2, mark, i, 1, 31);
                nego = true;
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S7) {
                if (digit.contains(c)) {
                    mark = i;
                    state = StateEnum.S8;
                    precision = ChronoField.HOUR_OF_DAY;
                    continue;
                }
                if (c == 'Z') {
                    zoneId = ZoneId.of("Z");
                    if (timeOnly) {
                        precision = ChronoField.HOUR_OF_DAY;
                    }
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    nego = false;
                    if (timeOnly) {
                        precision = ChronoField.HOUR_OF_DAY;
                    }
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                nego = true;
                if (timeOnly) {
                    precision = ChronoField.HOUR_OF_DAY;
                }
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S8) {
                if (digit.contains(c)) continue;
                if (c == ':') {
                    hour = GranularZonedDateTime.parse(value, 2, mark, i, 0, 23);
                    state = StateEnum.S9;
                    continue;
                }
                if (c == 'Z') {
                    hour = GranularZonedDateTime.parse(value, 2, mark, i, 0, 23);
                    zoneId = ZoneId.of("Z");
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    hour = GranularZonedDateTime.parse(value, 2, mark, i, 0, 23);
                    nego = false;
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                hour = GranularZonedDateTime.parse(value, 2, mark, i, 0, 23);
                nego = true;
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S9) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S10;
                precision = ChronoField.MINUTE_OF_HOUR;
                continue;
            }
            if (state == StateEnum.S10) {
                if (digit.contains(c)) continue;
                if (c == ':') {
                    minute = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                    state = StateEnum.S11;
                    continue;
                }
                if (c == 'Z') {
                    minute = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                    zoneId = ZoneId.of("Z");
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    minute = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                    nego = false;
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                minute = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                nego = true;
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S11) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S12;
                precision = ChronoField.SECOND_OF_MINUTE;
                continue;
            }
            if (state == StateEnum.S12) {
                if (digit.contains(c)) continue;
                if (c == '.' || c == ',') {
                    second = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                    state = StateEnum.S13;
                    continue;
                }
                if (c == 'Z') {
                    second = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                    zoneId = ZoneId.of("Z");
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    second = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                    nego = false;
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                second = GranularZonedDateTime.parse(value, 2, mark, i, 0, 59);
                nego = true;
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S13) {
                if (digit.contains(c)) {
                    mark = i;
                    state = StateEnum.S14;
                    continue;
                }
                if (c == 'Z') {
                    zoneId = ZoneId.of("Z");
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    nego = false;
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                nego = true;
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S14) {
                int digitCount;
                if (digit.contains(c)) continue;
                if (c == 'Z') {
                    nanos = GranularZonedDateTime.parseNanos(value, mark, i);
                    zoneId = ZoneId.of("Z");
                    digitCount = i - mark;
                    precision = digitCount <= 3 ? ChronoField.MILLI_OF_SECOND : ChronoField.NANO_OF_SECOND;
                    state = StateEnum.S15;
                    continue;
                }
                if (c == '+') {
                    nanos = GranularZonedDateTime.parseNanos(value, mark, i);
                    digitCount = i - mark;
                    precision = digitCount <= 3 ? ChronoField.MILLI_OF_SECOND : ChronoField.NANO_OF_SECOND;
                    nego = false;
                    state = StateEnum.S16;
                    continue;
                }
                if (c != '-') throw GranularZonedDateTime.bad(value, i);
                nanos = GranularZonedDateTime.parseNanos(value, mark, i);
                digitCount = i - mark;
                precision = digitCount <= 3 ? ChronoField.MILLI_OF_SECOND : ChronoField.NANO_OF_SECOND;
                nego = true;
                state = StateEnum.S17;
                continue;
            }
            if (state == StateEnum.S15) {
                throw GranularZonedDateTime.bad(value, i);
            }
            if (state == StateEnum.S16) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S18;
                continue;
            }
            if (state == StateEnum.S17) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S18;
                continue;
            }
            if (state == StateEnum.S18) {
                if (digit.contains(c)) continue;
                if (c != ':') throw GranularZonedDateTime.bad(value, i);
                ohour = GranularZonedDateTime.parse(value, 2, mark, i, 0, 18);
                state = StateEnum.S19;
                continue;
            }
            if (state == StateEnum.S19) {
                if (!digit.contains(c)) throw GranularZonedDateTime.bad(value, i);
                mark = i;
                state = StateEnum.S20;
                continue;
            }
            if (digit.contains(c)) continue;
            throw GranularZonedDateTime.bad(value, i);
        }
        int end = value.length();
        if (state.isAny(StateEnum.S1, StateEnum.S3, StateEnum.S5, StateEnum.S7, StateEnum.S9, StateEnum.S11, StateEnum.S13, StateEnum.S16, StateEnum.S17, StateEnum.S19)) {
            throw GranularZonedDateTime.bad(value, end - 1);
        }
        if (state == StateEnum.S2) {
            year = GranularZonedDateTime.parse(value, 4, mark, end, 0, 9999);
            precision = ChronoField.YEAR;
        } else if (state == StateEnum.S4) {
            month = GranularZonedDateTime.parse(value, 2, mark, end, 1, 12);
            precision = ChronoField.MONTH_OF_YEAR;
        } else if (state == StateEnum.S6) {
            day = GranularZonedDateTime.parse(value, 2, mark, end, 1, 31);
            precision = ChronoField.DAY_OF_MONTH;
        } else if (state == StateEnum.S8) {
            hour = GranularZonedDateTime.parse(value, 2, mark, end, 0, 23);
            precision = ChronoField.HOUR_OF_DAY;
        } else if (state == StateEnum.S10) {
            minute = GranularZonedDateTime.parse(value, 2, mark, end, 0, 59);
            precision = ChronoField.MINUTE_OF_HOUR;
        } else if (state == StateEnum.S12) {
            second = GranularZonedDateTime.parse(value, 2, mark, end, 0, 59);
            precision = ChronoField.SECOND_OF_MINUTE;
        } else if (state == StateEnum.S14) {
            nanos = GranularZonedDateTime.parseNanos(value, mark, end);
            int digitCount = end - mark;
            precision = digitCount <= 3 ? ChronoField.MILLI_OF_SECOND : ChronoField.NANO_OF_SECOND;
        } else if (state != StateEnum.S15) {
            if (state == StateEnum.S18) {
                if (end - mark == 2) {
                    ohour = GranularZonedDateTime.parse(value, 2, mark, end, 0, 18);
                } else {
                    if (end - mark != 4) throw GranularZonedDateTime.bad(value, mark);
                    ohour = GranularZonedDateTime.parse(value, 2, mark, mark + 2, 0, 18);
                    ominute = GranularZonedDateTime.parse(value, 2, mark + 2, end, 0, 59);
                }
            } else {
                ominute = GranularZonedDateTime.parse(value, 2, mark, end, 0, 59);
            }
        }
        if (zoneId == null && ohour >= 0) {
            if (ominute >= 0) {
                ZoneOffset offset = ZoneOffset.ofHoursMinutes(nego ? -ohour : ohour, nego ? -ominute : ominute);
                zoneId = offset;
            } else {
                ZoneOffset offset = ZoneOffset.ofHours(nego ? -ohour : ohour);
                zoneId = offset;
            }
        }
        if (zoneId == null) {
            ZoneId zoneId2 = zoneId = defaultZoneId != null ? defaultZoneId : timeProvider.getSystemDefaultZoneId();
        }
        if (timeOnly) {
            ZonedDateTime now = timeProvider.now(zoneId);
            year = now.getYear();
            month = now.getMonthValue();
            day = now.getDayOfMonth();
        }
        LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second);
        if (nanos > 0) {
            localDateTime = localDateTime.plusNanos(nanos);
        }
        ZonedDateTime zdt = ZonedDateTime.of(localDateTime, zoneId);
        return new GranularZonedDateTime(zdt, precision);
    }

    public static GranularZonedDateTime of(ZonedDateTime date, ChronoField precision) {
        return new GranularZonedDateTime(date, precision);
    }

    private static DateTimeParseException bad(String s, int pos) {
        return new DateTimeParseException("Invalid ISO8601 timestamp", s, pos);
    }

    private static int parse(String s, int chars, int pos, int end, int min, int max) {
        if (end - pos != chars) {
            throw GranularZonedDateTime.bad(s, pos);
        }
        int i = Integer.parseInt(s, pos, end, 10);
        if (i < min || i > max) {
            throw GranularZonedDateTime.bad(s, pos);
        }
        return i;
    }

    private static int parseNanos(String s, int pos, int end) {
        int len = end - pos;
        if (len > 9) {
            throw GranularZonedDateTime.bad(s, pos);
        }
        int n = Integer.parseInt(s, pos, end, 10);
        if (len == 1) {
            return n * 100000000;
        }
        if (len == 2) {
            return n * 10000000;
        }
        if (len == 3) {
            return n * 1000000;
        }
        if (len == 4) {
            return n * 100000;
        }
        if (len == 5) {
            return n * 10000;
        }
        if (len == 6) {
            return n * 1000;
        }
        if (len == 7) {
            return n * 100;
        }
        if (len == 8) {
            return n * 10;
        }
        return n;
    }

    private static ChronoUnit toChronoUnit(ChronoField field) {
        return switch (field) {
            case ChronoField.YEAR -> ChronoUnit.YEARS;
            case ChronoField.MONTH_OF_YEAR -> ChronoUnit.MONTHS;
            case ChronoField.DAY_OF_MONTH -> ChronoUnit.DAYS;
            case ChronoField.HOUR_OF_DAY -> ChronoUnit.HOURS;
            case ChronoField.MINUTE_OF_HOUR -> ChronoUnit.MINUTES;
            case ChronoField.SECOND_OF_MINUTE -> ChronoUnit.SECONDS;
            case ChronoField.MILLI_OF_SECOND -> ChronoUnit.MILLIS;
            case ChronoField.NANO_OF_SECOND -> ChronoUnit.NANOS;
            default -> null;
        };
    }

    public GranularZonedDateTime(ZonedDateTime zdt, ChronoField precision) {
        this.zdt = zdt;
        this.precision = precision;
    }

    public GranularZonedDateTime copy() {
        return new GranularZonedDateTime(this.zdt, this.precision);
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zdt;
    }

    public ChronoField getPrecision() {
        return this.precision;
    }

    public String toString() {
        return this.zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "(" + String.valueOf(this.precision) + ")";
    }

    public GranularZonedDateTime roll(ChronoField field, int amount) {
        ChronoUnit unit = GranularZonedDateTime.toChronoUnit(field);
        AssertionUtils.assertArg(unit != null, "Unsupported roll field: {0}", field);
        ZonedDateTime newZdt = this.zdt.plus(amount, unit);
        return new GranularZonedDateTime(newZdt, this.precision);
    }

    public GranularZonedDateTime roll(int amount) {
        return this.roll(this.precision, amount);
    }
}

