/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.resultset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.EqualityTest;
import org.apache.jena.sparql.util.NodeUtils;
import org.apache.jena.sparql.util.iso.BNodeIso;
import org.apache.jena.sparql.util.iso.IsoAlgRows;

public class ResultsCompare {
    public static boolean equalsByValue(ResultSet rs1, ResultSet rs2) {
        return ResultsCompare.equalsByValue(RowSet.adapt(rs1), RowSet.adapt(rs2));
    }

    public static boolean equalsByValue(RowSet rs1, RowSet rs2) {
        return IsoAlgRows.isomorphic(rs1, rs2, BNodeIso.Match.BNODES_VALUE);
    }

    public static boolean equalsByTerm(ResultSet rs1, ResultSet rs2) {
        return ResultsCompare.equalsByTerm(RowSet.adapt(rs1), RowSet.adapt(rs2));
    }

    public static boolean equalsByTerm(RowSet rs1, RowSet rs2) {
        return IsoAlgRows.isomorphic(rs1, rs2, BNodeIso.Match.BNODES_TERM);
    }

    public static boolean equalsByTerm(List<Binding> list1, List<Binding> list2) {
        return IsoAlgRows.isomorphic(list1, list2, BNodeIso.Match.BNODES_TERM);
    }

    public static boolean equalsByValueAndOrder(ResultSet rs1, ResultSet rs2) {
        return ResultsCompare.equalsByValueAndOrder(RowSet.adapt(rs1), RowSet.adapt(rs2));
    }

    public static boolean equalsByValueAndOrder(RowSet rs1, RowSet rs2) {
        if (!ResultsCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultsCompare.equivalentByOrder(ResultsCompare.convert(rs1), ResultsCompare.convert(rs2), BNodeIso.bnodeIsoByValue());
    }

    public static boolean equalsByTermAndOrder(ResultSet rs1, ResultSet rs2) {
        return ResultsCompare.equalsByTermAndOrder(RowSet.adapt(rs1), RowSet.adapt(rs2));
    }

    public static boolean equalsByTermAndOrder(RowSet rs1, RowSet rs2) {
        if (!ResultsCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultsCompare.equivalentByOrder(ResultsCompare.convert(rs1), ResultsCompare.convert(rs2), BNodeIso.bnodeIsoByTerm());
    }

    public static boolean equalsExact(ResultSet rs1, ResultSet rs2) {
        return ResultsCompare.equalsExact(RowSet.adapt(rs1), RowSet.adapt(rs2));
    }

    public static boolean equalsExact(RowSet rs1, RowSet rs2) {
        if (!ResultsCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultsCompare.equalsExact(ResultsCompare.convert(rs1), ResultsCompare.convert(rs2));
    }

    public static boolean equalsExact(List<Binding> list1, List<Binding> list2) {
        list2 = new ArrayList<Binding>(list2);
        if (list1.size() != list2.size()) {
            return false;
        }
        for (Binding binding : list1) {
            boolean wasPresent = list2.remove(binding);
            if (wasPresent) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsExactAndOrder(List<Binding> list1, List<Binding> list2) {
        return ResultsCompare.equivalentByOrder(list1, list2, NodeUtils.sameRdfTerm);
    }

    public static boolean equal(Binding bind1, Binding bind2, EqualityTest test) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        return ResultsCompare.containedIn(bind1, bind2, test);
    }

    private static boolean compareHeader(RowSet rs1, RowSet rs2) {
        if (rs1 == null && rs2 == null) {
            return true;
        }
        if (rs1 == null) {
            return false;
        }
        if (rs2 == null) {
            return false;
        }
        Set<Var> names1 = Set.copyOf(rs1.getResultVars());
        Set<Var> names2 = Set.copyOf(rs2.getResultVars());
        return names1.equals(names2);
    }

    private static List<Binding> convert(RowSet rs) {
        return Iter.iter((Iterator)((Object)rs)).toList();
    }

    private static boolean equivalentByOrder(List<Binding> rows1, List<Binding> rows2, EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        Iterator<Binding> iter1 = rows1.iterator();
        Iterator<Binding> iter2 = rows2.iterator();
        while (iter1.hasNext()) {
            Binding row2;
            Binding row1 = iter1.next();
            if (ResultsCompare.equal(row1, row2 = iter2.next(), match)) continue;
            return false;
        }
        return true;
    }

    private static boolean containedIn(Binding bind1, Binding bind2, EqualityTest test) {
        Iterator<Var> iter1 = bind1.vars();
        while (iter1.hasNext()) {
            Var v = iter1.next();
            Node n1 = bind1.get(v);
            Node n2 = bind2.get(v);
            if (n2 == null) {
                return false;
            }
            if (test.equal(n1, n2)) continue;
            return false;
        }
        return true;
    }
}

