/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.wal;

import com.google.protobuf.ByteString;
import com.google.protobuf.Parser;
import java.util.NoSuchElementException;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basekv.localengine.IKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.IKVSpaceRefreshableReader;
import org.apache.bifromq.basekv.localengine.IWALableKVSpace;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.wal.KVRangeWALKeys;
import org.apache.bifromq.basekv.utils.BoundaryUtil;

final class LogEntryIterator
implements ILogEntryIterator {
    private final IKVSpaceIterator iterator;
    private final long endIndex;
    private final long maxSize;
    private final Runnable cleanable;
    private long currentIndex;
    private long accumulatedSize;

    LogEntryIterator(IWALableKVSpace kvSpace, long startIndex, long endIndex, long maxSize, int logEntriesKeyInfix) {
        IKVSpaceRefreshableReader reader = kvSpace.reader();
        ByteString startBound = KVRangeWALKeys.logEntriesKeyPrefixInfix(logEntriesKeyInfix);
        ByteString endBound = BoundaryUtil.upperBound((ByteString)KVRangeWALKeys.logEntriesKeyPrefixInfix(logEntriesKeyInfix));
        this.iterator = reader.newIterator(Boundary.newBuilder().setStartKey(startBound).setEndKey(endBound).build());
        this.endIndex = endIndex;
        this.maxSize = maxSize;
        this.currentIndex = startIndex;
        this.accumulatedSize = 0L;
        ByteString startKey = KVRangeWALKeys.logEntryKey(logEntriesKeyInfix, startIndex);
        this.iterator.seek(startKey);
        this.cleanable = new NativeResource(reader, this.iterator);
    }

    public boolean hasNext() {
        return this.currentIndex < this.endIndex && this.accumulatedSize <= this.maxSize && this.iterator.isValid();
    }

    public LogEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            ByteString value = this.iterator.value();
            ++this.currentIndex;
            LogEntry entry = (LogEntry)ZeroCopyParser.parse((ByteString)value, (Parser)LogEntry.parser());
            this.accumulatedSize += (long)entry.getData().size();
            this.iterator.next();
            return entry;
        }
        catch (Throwable e) {
            throw new KVRangeStoreException("Log data corruption", e);
        }
    }

    public void close() {
        this.cleanable.run();
    }

    private record NativeResource(IKVSpaceRefreshableReader reader, IKVSpaceIterator itr) implements Runnable
    {
        @Override
        public void run() {
            this.itr.close();
            this.reader.close();
        }
    }
}

