/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basescheduler;

import java.util.Map;
import lombok.Generated;
import org.apache.bifromq.basehookloader.BaseHookLoader;
import org.apache.bifromq.basescheduler.spi.ICallScheduler;
import org.apache.bifromq.basescheduler.spi.ICallSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallSchedulerFactory
implements ICallSchedulerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallSchedulerFactory.class);
    public static final ICallSchedulerFactory INSTANCE = new CallSchedulerFactory();
    private final ICallSchedulerFactory delegate;

    private CallSchedulerFactory() {
        Map factoryMap = BaseHookLoader.load(ICallSchedulerFactory.class);
        this.delegate = factoryMap.isEmpty() ? FallbackCallSchedulerFactory.INSTANCE : (ICallSchedulerFactory)factoryMap.values().iterator().next();
    }

    @Override
    public <ReqT> ICallScheduler<ReqT> create(String name) {
        try {
            ICallScheduler scheduler = this.delegate.create(name);
            if (scheduler == null) {
                return FallbackCallSchedulerFactory.INSTANCE.create(name);
            }
            return scheduler;
        }
        catch (Throwable e) {
            log.error("Failed to create pipelineDepthEstimator: scheduler={}", (Object)name, (Object)e);
            return FallbackCallSchedulerFactory.INSTANCE.create(name);
        }
    }

    private static class FallbackCallSchedulerFactory
    implements ICallSchedulerFactory {
        private static final ICallSchedulerFactory INSTANCE = new FallbackCallSchedulerFactory();

        private FallbackCallSchedulerFactory() {
        }

        @Override
        public <ReqT> ICallScheduler<ReqT> create(String name) {
            return new ICallScheduler<ReqT>(){};
        }
    }
}

