/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.Hll6Array;
import org.apache.datasketches.hll.HllPairIterator;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

final class DirectHll6Array
extends DirectHllArray {
    DirectHll6Array(int lgConfigK, MemorySegment wseg) {
        super(lgConfigK, TgtHllType.HLL_6, wseg);
    }

    DirectHll6Array(int lgConfigK, MemorySegment seg, boolean readOnly) {
        super(lgConfigK, TgtHllType.HLL_6, seg, readOnly);
    }

    @Override
    HllSketchImpl copy() {
        return Hll6Array.heapify(this.seg);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        if (this.wseg == null) {
            HllUtil.noWriteAccess();
        }
        int newValue = HllUtil.getPairValue(coupon);
        int configKmask = (1 << this.getLgConfigK()) - 1;
        int slotNo = HllUtil.getPairLow26(coupon) & configKmask;
        this.updateSlotWithKxQ(slotNo, newValue);
        return this;
    }

    @Override
    int getHllByteArrBytes() {
        return DirectHll6Array.hll6ArrBytes(this.lgConfigK);
    }

    @Override
    int getNibble(int slotNo) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    int getSlotValue(int slotNo) {
        return DirectHll6Array.get6Bit(this.seg, PreambleUtil.HLL_BYTE_ARR_START, slotNo);
    }

    @Override
    PairIterator iterator() {
        return new DirectHll6Iterator(this, 1 << this.lgConfigK);
    }

    @Override
    void putNibble(int slotNo, int nibValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotNoKxQ(int slotNo, int newValue) {
        throw new SketchesStateException("Improper access.");
    }

    @Override
    void updateSlotWithKxQ(int slotNo, int newValue) {
        int oldValue = this.getSlotValue(slotNo);
        if (newValue > oldValue) {
            DirectHll6Array.put6Bit(this.wseg, PreambleUtil.HLL_BYTE_ARR_START, slotNo, newValue);
            DirectHll6Array.hipAndKxQIncrementalUpdate(this, oldValue, newValue);
            if (oldValue == 0) {
                this.decNumAtCurMin();
                assert (this.getNumAtCurMin() >= 0);
            }
        }
    }

    private static void put6Bit(MemorySegment wseg, int offsetBytes, int slotNo, int newValue) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        int valShifted = (newValue & 0x3F) << shift;
        int curMasked = wseg.get(ValueLayout.JAVA_SHORT_UNALIGNED, (long)byteIdx) & ~(63 << shift);
        short insert = (short)(curMasked | valShifted);
        wseg.set(ValueLayout.JAVA_SHORT_UNALIGNED, (long)byteIdx, insert);
    }

    private static int get6Bit(MemorySegment seg, int offsetBytes, int slotNo) {
        int startBit = slotNo * 6;
        int shift = startBit & 7;
        int byteIdx = (startBit >>> 3) + offsetBytes;
        return (byte)(seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, (long)byteIdx) >>> shift & 0x3F);
    }

    final class DirectHll6Iterator
    extends HllPairIterator {
        int bitOffset;
        final /* synthetic */ DirectHll6Array this$0;

        DirectHll6Iterator(DirectHll6Array this$0, int lengthPairs) {
            DirectHll6Array directHll6Array = this$0;
            Objects.requireNonNull(directHll6Array);
            this.this$0 = directHll6Array;
            super(lengthPairs);
            this.bitOffset = -6;
        }

        @Override
        int value() {
            this.bitOffset += 6;
            short tmp = this.this$0.seg.get(ValueLayout.JAVA_SHORT_UNALIGNED, (long)(PreambleUtil.HLL_BYTE_ARR_START + this.bitOffset / 8));
            int shift = this.bitOffset % 8 & 7;
            return tmp >>> shift & 0x3F;
        }
    }
}

