/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.undo.JTextFieldUndoListener;
import org.apache.cayenne.validation.ValidationException;

public abstract class TextAdapter {
    protected Color defaultBGColor;
    protected Color errorColor = ValidatorDialog.WARNING_COLOR;
    protected String defaultToolTip;
    protected boolean modelUpdateDisabled;
    protected UndoableEditListener undoableListener;
    protected JTextComponent textComponent;

    public TextAdapter(JTextField textField) {
        this(textField, true, false, true);
    }

    public TextAdapter(JTextField textField, boolean checkOnFocusLost, boolean checkOnTyping, boolean checkOnEnter) {
        this(textField, true, false);
        if (checkOnEnter) {
            textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextAdapter.this.updateModel();
                }
            });
        }
    }

    public TextAdapter(JTextComponent textField) {
        this(textField, false, true);
    }

    public TextAdapter(JTextComponent textComponent, boolean checkOnFocusLost, boolean checkOnTyping) {
        this.defaultBGColor = textComponent.getBackground();
        this.defaultToolTip = textComponent.getToolTipText();
        this.textComponent = textComponent;
        this.undoableListener = new JTextFieldUndoListener(this);
        this.textComponent.getDocument().addUndoableEditListener(this.undoableListener);
        if (checkOnFocusLost) {
            textComponent.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent c) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextAdapter.this.updateModel();
                        }
                    });
                    return true;
                }
            });
        }
        if (checkOnTyping) {
            textComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.verifyTextChange(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.verifyTextChange(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.verifyTextChange(e);
                }

                void verifyTextChange(DocumentEvent e) {
                    if (!TextAdapter.this.modelUpdateDisabled) {
                        TextAdapter.this.updateModel();
                    }
                }
            });
        }
    }

    protected abstract void updateModel(String var1) throws ValidationException;

    public JTextComponent getComponent() {
        return this.textComponent;
    }

    public void setText(String text) {
        this.modelUpdateDisabled = true;
        this.textComponent.getDocument().removeUndoableEditListener(this.undoableListener);
        try {
            this.clear();
            this.textComponent.setText(text);
        }
        finally {
            this.modelUpdateDisabled = false;
            this.textComponent.getDocument().addUndoableEditListener(this.undoableListener);
        }
    }

    public void updateModel() {
        try {
            this.updateModel(this.textComponent.getText());
            this.clear();
        }
        catch (ValidationException vex) {
            this.textComponent.setBackground(this.errorColor);
            this.textComponent.setToolTipText(vex.getUnlabeledMessage());
        }
    }

    protected void clear() {
        this.textComponent.setBackground(this.defaultBGColor);
        this.textComponent.setToolTipText(this.defaultToolTip);
    }
}

