/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.ee;

import jakarta.transaction.NotSupportedException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.LinkedList;
import org.apache.openjpa.ee.AbstractManagedRuntime;
import org.apache.openjpa.ee.InvocationManagedRuntime;
import org.apache.openjpa.ee.JNDIManagedRuntime;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.ee.SunOneManagedRuntime;
import org.apache.openjpa.ee.WASManagedRuntime;
import org.apache.openjpa.ee.WASRegistryManagedRuntime;
import org.apache.openjpa.ee.WLSManagedRuntime;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InvalidStateException;

public class AutomaticManagedRuntime
extends AbstractManagedRuntime
implements ManagedRuntime,
Configurable {
    private static final String[] JNDI_LOCS = new String[]{"jakarta.transaction.TransactionManager", "java:/TransactionManager", "java:/DefaultDomain/TransactionManager", "java:comp/pm/TransactionManager", "java:comp/TransactionManager", "java:appserver/TransactionManager", "java:pm/TransactionManager", "aries:services/jakarta.transaction.TransactionManager"};
    private static final String[] METHODS = new String[]{"com.arjuna.jta.JTA_TransactionManager.transactionManager", "com.bluestone.jta.SaTransactionManagerFactory.SaGetTransactionManager", "org.openejb.OpenEJB.getTransactionManager", "com.sun.jts.jta.TransactionManagerImpl.getTransactionManagerImpl", "com.inprise.visitransact.jta.TransactionManagerImpl.getTransactionManagerImpl"};
    private final ManagedRuntime REGISTRY;
    private final WLSManagedRuntime WLS;
    private final SunOneManagedRuntime SUNONE;
    private final WASManagedRuntime WAS;
    private final WASRegistryManagedRuntime WAS_REG;
    private static Localizer _loc = Localizer.forPackage(AutomaticManagedRuntime.class);
    private Configuration _conf = null;
    private ManagedRuntime _runtime = null;

    public AutomaticManagedRuntime() {
        ManagedRuntime mr = null;
        mr = null;
        try {
            mr = (ManagedRuntime)Class.forName("org.apache.openjpa.ee.RegistryManagedRuntime").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.REGISTRY = mr;
        mr = null;
        try {
            mr = new WLSManagedRuntime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.WLS = (WLSManagedRuntime)mr;
        mr = null;
        try {
            mr = new SunOneManagedRuntime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.SUNONE = (SunOneManagedRuntime)mr;
        mr = null;
        try {
            mr = new WASManagedRuntime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.WAS = (WASManagedRuntime)mr;
        mr = null;
        try {
            ClassLoader cl = AutomaticManagedRuntime.class.getClassLoader();
            Class<?> mrClass = J2DoPrivHelper.getForNameAction(WASRegistryManagedRuntime.class.getName(), true, cl).run();
            mr = (ManagedRuntime)J2DoPrivHelper.newInstanceAction(mrClass).run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.WAS_REG = (WASRegistryManagedRuntime)mr;
    }

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        if (this._runtime != null) {
            return this._runtime.getTransactionManager();
        }
        LinkedList<Throwable> errors = new LinkedList<Throwable>();
        TransactionManager tm = null;
        if (this.WAS_REG != null) {
            try {
                tm = this.WAS_REG.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = this.WAS_REG;
                return tm;
            }
        }
        if (this.REGISTRY != null) {
            try {
                tm = this.REGISTRY.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = this.REGISTRY;
                return tm;
            }
        }
        if (this.WLS != null) {
            try {
                tm = this.WLS.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = this.WLS;
                return tm;
            }
        }
        if (this.WAS != null) {
            try {
                this.WAS.setConfiguration(this._conf);
                this.WAS.startConfiguration();
                this.WAS.endConfiguration();
                tm = this.WAS.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = this.WAS;
                return tm;
            }
        }
        JNDIManagedRuntime jmr = new JNDIManagedRuntime();
        for (String jndiLoc : JNDI_LOCS) {
            jmr.setTransactionManagerName(jndiLoc);
            try {
                tm = jmr.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm == null) continue;
            this._runtime = jmr;
            return tm;
        }
        InvocationManagedRuntime imr = new InvocationManagedRuntime();
        for (String method : METHODS) {
            imr.setConfiguration(this._conf);
            imr.setTransactionManagerMethod(method);
            try {
                tm = imr.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm == null) continue;
            this._runtime = imr;
            return tm;
        }
        if (this.SUNONE != null) {
            try {
                tm = this.SUNONE.getTransactionManager();
            }
            catch (Throwable t) {
                errors.add(t);
            }
            if (tm != null) {
                this._runtime = this.SUNONE;
                return tm;
            }
        }
        Throwable[] t = errors.toArray(new Throwable[errors.size()]);
        throw new InvalidStateException(_loc.get("tm-not-found")).setFatal(true).setNestedThrowables(t);
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = conf;
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
    }

    @Override
    public void setRollbackOnly(Throwable cause) throws Exception {
        if (this._runtime == null) {
            this.getTransactionManager();
        }
        if (this._runtime != null) {
            this._runtime.setRollbackOnly(cause);
        }
    }

    @Override
    public Throwable getRollbackCause() throws Exception {
        if (this._runtime == null) {
            this.getTransactionManager();
        }
        if (this._runtime != null) {
            return this._runtime.getRollbackCause();
        }
        return null;
    }

    @Override
    public Object getTransactionKey() throws Exception, SystemException {
        if (this._runtime == null) {
            this.getTransactionManager();
        }
        if (this._runtime != null) {
            return this._runtime.getTransactionKey();
        }
        return null;
    }

    @Override
    public void doNonTransactionalWork(Runnable runnable) throws NotSupportedException {
        try {
            this.getTransactionManager();
        }
        catch (Exception e) {
            NotSupportedException nse = new NotSupportedException(_loc.get("tm-unavailable", this._runtime).getMessage());
            nse.initCause((Throwable)e);
            throw nse;
        }
        this._runtime.doNonTransactionalWork(runnable);
    }
}

