/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openjpa.lib.conf.BootstrapException;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.ProductDerivation;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.Services;
import org.apache.openjpa.lib.util.StringUtil;

public class ProductDerivations {
    private static final Localizer _loc;
    private static final ProductDerivation[] _derivations;
    private static final String[] _derivationNames;
    private static final Throwable[] _derivationErrors;
    private static String[] _prefixes;

    public static ProductDerivation[] getProductDerivations() {
        return _derivations;
    }

    public static String[] getConfigurationPrefixes() {
        return _prefixes;
    }

    static void setConfigurationPrefixes(String[] prefixes) {
        _prefixes = prefixes;
    }

    public static String getConfigurationKey(String partialKey, Map map) {
        Object firstKey = map != null && map.containsKey(partialKey) ? partialKey : null;
        for (int i = 0; map != null && i < _prefixes.length; ++i) {
            String fullKey = _prefixes[i] + "." + partialKey;
            if (!map.containsKey(fullKey)) continue;
            if (firstKey == null) {
                firstKey = fullKey;
                continue;
            }
            throw new IllegalStateException(_loc.get("dup-with-different-prefixes", firstKey, fullKey).getMessage());
        }
        if (firstKey == null) {
            return _prefixes[0] + "." + partialKey;
        }
        return firstKey;
    }

    public static void beforeConfigurationConstruct(ConfigurationProvider cp) {
        for (ProductDerivation derivation : _derivations) {
            try {
                derivation.beforeConfigurationConstruct(cp);
            }
            catch (BootstrapException be) {
                if (!be.isFatal()) continue;
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void beforeConfigurationLoad(Configuration conf) {
        for (ProductDerivation derivation : _derivations) {
            try {
                derivation.beforeConfigurationLoad(conf);
            }
            catch (BootstrapException be) {
                if (!be.isFatal()) continue;
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void afterSpecificationSet(Configuration conf) {
        for (ProductDerivation derivation : _derivations) {
            try {
                derivation.afterSpecificationSet(conf);
            }
            catch (BootstrapException be) {
                if (!be.isFatal()) continue;
                throw be;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void beforeClose(Configuration conf) {
        for (ProductDerivation derivation : _derivations) {
            try {
                derivation.beforeConfigurationClose(conf);
            }
            catch (Exception e) {
                conf.getConfigurationLog().warn(_loc.get("before-close-ex"), e);
            }
        }
    }

    public static ConfigurationProvider load(String resource, String anchor, ClassLoader loader) {
        if (StringUtil.isEmpty(resource)) {
            return null;
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        ConfigurationProvider provider = null;
        StringBuilder errs = null;
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                provider = _derivations[i].load(resource, anchor, loader);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuilder() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + String.valueOf(t));
            }
        }
        ProductDerivations.reportErrors(errs, resource, err);
        String rsrc = resource + "#" + anchor;
        MissingResourceException ex = new MissingResourceException(rsrc, ProductDerivations.class.getName(), rsrc);
        ex.initCause(err);
        throw ex;
    }

    public static ConfigurationProvider load(File file, String anchor, ClassLoader loader) {
        if (file == null) {
            return null;
        }
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        ConfigurationProvider provider = null;
        StringBuilder errs = null;
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                provider = _derivations[i].load(file, anchor);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuilder() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + String.valueOf(t));
            }
        }
        String aPath = AccessController.doPrivileged(J2DoPrivHelper.getAbsolutePathAction(file));
        ProductDerivations.reportErrors(errs, aPath, err);
        String rsrc = aPath + "#" + anchor;
        MissingResourceException ex = new MissingResourceException(rsrc, ProductDerivations.class.getName(), rsrc);
        ex.initCause(err);
        throw ex;
    }

    public static ConfigurationProvider loadDefaults(ClassLoader loader) {
        return ProductDerivations.load(loader, false);
    }

    public static ConfigurationProvider loadGlobals(ClassLoader loader) {
        return ProductDerivations.load(loader, true);
    }

    private static ConfigurationProvider load(ClassLoader loader, boolean globals) {
        if (loader == null) {
            loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        ConfigurationProvider provider = null;
        StringBuilder errs = null;
        String type = globals ? "globals" : "defaults";
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                ConfigurationProvider configurationProvider = provider = globals ? _derivations[i].loadGlobals(loader) : _derivations[i].loadDefaults(loader);
                if (provider == null) continue;
                return provider;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuilder() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + String.valueOf(t));
            }
        }
        ProductDerivations.reportErrors(errs, type, err);
        return null;
    }

    private static void reportErrors(StringBuilder errs, String resource, Throwable nested) {
        if (errs == null) {
            return;
        }
        MissingResourceException ex = new MissingResourceException(errs.toString(), ProductDerivations.class.getName(), resource);
        ex.initCause(nested);
        throw ex;
    }

    public static List<String> getFullyQualifiedAnchorsInPropertiesLocation(String propertiesLocation) {
        ArrayList<String> fqAnchors = new ArrayList<String>();
        StringBuilder errs = null;
        Throwable err = null;
        for (int i = _derivations.length - 1; i >= 0; --i) {
            try {
                if (propertiesLocation == null) {
                    String loc = _derivations[i].getDefaultResourceLocation();
                    ProductDerivations.addAll(fqAnchors, loc, _derivations[i].getAnchorsInResource(loc));
                    continue;
                }
                File f = new File(propertiesLocation);
                if (J2DoPrivHelper.isFileAction(f).run().booleanValue()) {
                    ProductDerivations.addAll(fqAnchors, propertiesLocation, _derivations[i].getAnchorsInFile(f));
                    continue;
                }
                f = new File("META-INF" + File.separatorChar + propertiesLocation);
                if (J2DoPrivHelper.isFileAction(f).run().booleanValue()) {
                    ProductDerivations.addAll(fqAnchors, propertiesLocation, _derivations[i].getAnchorsInFile(f));
                    continue;
                }
                ProductDerivations.addAll(fqAnchors, propertiesLocation, _derivations[i].getAnchorsInResource(propertiesLocation));
                continue;
            }
            catch (Throwable t) {
                err = t;
                errs = errs == null ? new StringBuilder() : errs.append("\n");
                errs.append(_derivations[i].getClass().getName() + ":" + String.valueOf(t));
            }
        }
        ProductDerivations.reportErrors(errs, propertiesLocation, err);
        return fqAnchors;
    }

    private static void addAll(Collection collection, String base, Collection newMembers) {
        if (newMembers == null || collection == null) {
            return;
        }
        for (Object newMember : newMembers) {
            String fqLoc = base + "#" + String.valueOf(newMember);
            if (collection.contains(fqLoc)) continue;
            collection.add(fqLoc);
        }
    }

    public static Set<String> getSupportedQueryHints() {
        TreeSet<String> result = new TreeSet<String>();
        for (int i = _derivations.length - 1; i >= 0; --i) {
            Set<String> members = _derivations[i].getSupportedQueryHints();
            if (members == null || members.isEmpty()) continue;
            result.addAll(members);
        }
        return result;
    }

    public static void main(String[] args) {
        System.err.println(ProductDerivations.derivationErrorsToString());
    }

    private static String derivationErrorsToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("ProductDerivations: ").append(_derivationNames.length);
        for (int i = 0; i < _derivationNames.length; ++i) {
            buf.append("\n").append(i + 1).append(". ").append(_derivationNames[i]).append(": ");
            if (_derivationErrors[i] == null) {
                buf.append("OK");
                continue;
            }
            buf.append(_derivationErrors[i].toString());
        }
        return buf.toString();
    }

    static {
        int i;
        _loc = Localizer.forPackage(ProductDerivations.class);
        MultiClassLoader l = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        l.addClassLoader(0, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(ProductDerivations.class)));
        l.addClassLoader(1, AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        _derivationNames = Services.getImplementors(ProductDerivation.class, (ClassLoader)l);
        _derivationErrors = new Throwable[_derivationNames.length];
        ArrayList<ProductDerivation> derivations = new ArrayList<ProductDerivation>(_derivationNames.length);
        boolean errors = false;
        for (i = 0; i < _derivationNames.length; ++i) {
            try {
                ProductDerivation d = (ProductDerivation)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(Class.forName(_derivationNames[i], true, l)));
                d.validate();
                derivations.add(d);
                continue;
            }
            catch (Throwable t2) {
                Exception t2;
                if (t2 instanceof PrivilegedActionException) {
                    t2 = ((PrivilegedActionException)t2).getException();
                }
                ProductDerivations._derivationErrors[i] = t2;
                errors = true;
            }
        }
        if (derivations.isEmpty()) {
            throw new MissingResourceException(_loc.get("no-product-derivations", ProductDerivation.class.getName(), ProductDerivations.derivationErrorsToString()).getMessage(), ProductDerivations.class.getName(), "derivations");
        }
        if (errors) {
            System.err.println(_loc.get("bad-product-derivations", ProductDerivations.class.getName()));
        }
        for (i = 0; i < _derivationErrors.length; ++i) {
            if (_derivationErrors[i] == null) continue;
            System.err.println(_derivationNames[i] + ":" + String.valueOf(_derivationErrors[i]));
            break;
        }
        Collections.sort(derivations, new ProductDerivationComparator());
        _derivations = derivations.toArray(new ProductDerivation[derivations.size()]);
        ArrayList<String> prefixes = new ArrayList<String>(2);
        prefixes.add("openjpa");
        for (ProductDerivation derivation : _derivations) {
            String prefix = derivation.getConfigurationPrefix();
            if (prefix == null || "openjpa".equals(prefix)) continue;
            prefixes.add(prefix);
        }
        _prefixes = prefixes.toArray(new String[prefixes.size()]);
    }

    private static class ProductDerivationComparator
    implements Comparator<ProductDerivation> {
        private ProductDerivationComparator() {
        }

        @Override
        public int compare(ProductDerivation o1, ProductDerivation o2) {
            int type2;
            int type1 = o1.getType();
            if (type1 != (type2 = o2.getType())) {
                return type1 - type2;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    }
}

