/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.webbeans.custom.CustomProxyPackageMarker;
import org.apache.webbeans.custom.signed.CustomSignedProxyPackageMarker;
import org.apache.webbeans.exception.ProxyGenerationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class Unsafe {
    private final Object unsafe;
    private final Object internalUnsafe;
    private Method unsafeAllocateInstance;
    private final AtomicReference<Method> unsafeDefineClass;
    private volatile byte defineClassImpl;
    private volatile Method defineClassMethod;
    private volatile Method privateLookup;
    private Method defineClass;
    private MethodHandles.Lookup lookup;

    public Unsafe() {
        block8: {
            this.unsafeDefineClass = new AtomicReference();
            this.defineClassImpl = 0;
            this.defineClassMethod = null;
            Class<?> unsafeClass = this.getUnsafeClass();
            this.unsafe = AccessController.doPrivileged(() -> {
                try {
                    Field field = unsafeClass.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return field.get(null);
                }
                catch (Exception e) {
                    WebBeansLoggerFacade.getLogger(Unsafe.class).info("Cannot get sun.misc.Unsafe - will use newInstance() instead!");
                    return null;
                }
            });
            this.internalUnsafe = AccessController.doPrivileged(() -> {
                try {
                    Field theInternalUnsafe = unsafeClass.getDeclaredField("theInternalUnsafe");
                    theInternalUnsafe.setAccessible(true);
                    return theInternalUnsafe.get(null);
                }
                catch (Exception notJ11OrMore) {
                    return this.unsafe;
                }
            });
            if (this.unsafe != null) {
                this.unsafeAllocateInstance = AccessController.doPrivileged(() -> {
                    try {
                        Method mtd = this.unsafe.getClass().getDeclaredMethod("allocateInstance", Class.class);
                        mtd.setAccessible(true);
                        return mtd;
                    }
                    catch (Exception e) {
                        return null;
                    }
                });
                try {
                    Class<?> rootLoaderClass = Class.forName("java.lang.ClassLoader");
                    try {
                        Method getModule = Class.class.getMethod("getModule", new Class[0]);
                        Object module = getModule.invoke(rootLoaderClass, new Object[0]);
                        if (module != null) {
                            Method isOpen = module.getClass().getMethod("isOpen", String.class);
                            if (((Boolean)Boolean.class.cast(isOpen.invoke(module, "sun.misc"))).booleanValue()) {
                                this.oldStyleSetAccessibleDefineClass(rootLoaderClass);
                            } else {
                                this.hackSetDefineClassAccessible();
                            }
                            break block8;
                        }
                        this.hackSetDefineClassAccessible();
                    }
                    catch (NoSuchMethodException nsme) {
                        this.oldStyleSetAccessibleDefineClass(rootLoaderClass);
                    }
                }
                catch (Exception e) {
                    this.hackSetDefineClassAccessible();
                }
            }
        }
    }

    private void oldStyleSetAccessibleDefineClass(Class<?> rootLoaderClass) throws NoSuchMethodException {
        rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE).setAccessible(true);
        rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class).setAccessible(true);
    }

    private void hackSetDefineClassAccessible() {
        try {
            Class<?> rootLoaderClass = Class.forName("java.lang.ClassLoader");
            Method objectFieldOffset = this.unsafe.getClass().getDeclaredMethod("objectFieldOffset", Field.class);
            Method putBoolean = this.unsafe.getClass().getDeclaredMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            objectFieldOffset.setAccessible(true);
            long accOffset = (Long)Long.class.cast(objectFieldOffset.invoke(this.unsafe, AccessibleObject.class.getDeclaredField("override")));
            putBoolean.invoke(this.unsafe, rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE), accOffset, true);
            putBoolean.invoke(this.unsafe, rootLoaderClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), accOffset, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> Class<T> defineAndLoadClass(ClassLoader classLoader, String proxyName, byte[] proxyBytes, Class<?> parent) throws ProxyGenerationException {
        definedClass = null;
        try {
            switch (this.defineClassImpl) {
                case 0: 
                case 1: {
                    if (this.defineClassMethod == null) {
                        try {
                            defineClassMethodTmp = ClassLoader.class.getDeclaredMethod("defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
                            if (!defineClassMethodTmp.isAccessible()) {
                                try {
                                    defineClassMethodTmp.setAccessible(true);
                                    this.defineClassMethod = defineClassMethodTmp;
                                }
                                catch (RuntimeException var7_11) {}
                            }
                        }
                        catch (NoSuchMethodException var7_12) {
                            // empty catch block
                        }
                    }
                    if (this.defineClassMethod == null) ** GOTO lbl27
                    try {
                        definedClass = (Class)Class.class.cast(this.defineClassMethod.invoke((Object)classLoader, new Object[]{proxyName, proxyBytes, 0, proxyBytes.length}));
                        this.defineClassImpl = 1;
                    }
                    catch (Throwable t) {
                        definedClass = this.handleLinkageError(t, proxyName, classLoader);
                        if (definedClass == null) ** GOTO lbl27
                        this.defineClassImpl = 1;
                    }
                    break;
                }
lbl27:
                // 3 sources

                case 2: {
                    if (this.privateLookup == null) {
                        t = this;
                        synchronized (t) {
                            if (this.privateLookup == null) {
                                try {
                                    this.lookup = MethodHandles.lookup();
                                    this.defineClass = this.lookup.getClass().getMethod("defineClass", new Class[]{byte[].class});
                                    this.privateLookup = MethodHandles.class.getDeclaredMethod("privateLookupIn", new Class[]{Class.class, MethodHandles.Lookup.class});
                                }
                                catch (Exception var7_13) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (this.privateLookup == null) ** GOTO lbl54
                    try {
                        lookupInstance = (MethodHandles.Lookup)MethodHandles.Lookup.class.cast(this.privateLookup.invoke(null, new Object[]{proxyName.startsWith("org.apache.webbeans.custom.signed.") != false ? CustomSignedProxyPackageMarker.class : (proxyName.startsWith("org.apache.webbeans.custom.") != false ? CustomProxyPackageMarker.class : parent), this.lookup}));
                        definedClass = (Class)this.defineClass.invoke((Object)lookupInstance, new Object[]{proxyBytes});
                        this.defineClassImpl = (byte)2;
                    }
                    catch (Exception e) {
                        definedClass = this.handleLinkageError(e, proxyName, classLoader);
                        if (definedClass == null) ** GOTO lbl54
                        this.defineClassImpl = (byte)2;
                    }
                    break;
                }
lbl54:
                // 3 sources

                case 3: {
                    try {
                        definedClass = (Class)Class.class.cast(this.unsafeDefineClass().invoke(this.internalUnsafe, new Object[]{proxyName, proxyBytes, 0, proxyBytes.length, classLoader, null}));
                        this.defineClassImpl = (byte)3;
                    }
                    catch (Throwable t) {
                        definedClass = this.handleLinkageError(t, proxyName, classLoader);
                    }
                    break;
                }
                default: {
                    throw new IllegalAccessError("Unknown defineClass impl: " + this.defineClassImpl);
                }
            }
            if (definedClass == null) {
                throw new IllegalStateException("Can't define proxy " + proxyName);
            }
            return Class.forName(definedClass.getName(), true, classLoader);
        }
        catch (Throwable e) {
            return this.onProxyGenerationError(e, proxyName, classLoader);
        }
    }

    private <T> Class<T> onProxyGenerationError(Throwable throwable, String name, ClassLoader loader) {
        Class<T> clazz = this.handleLinkageError(throwable, name, loader);
        if (clazz != null) {
            return clazz;
        }
        throw new ProxyGenerationException(throwable.getMessage() + (this.isJava16OrMore() ? "\nOn Java 16 you can set --add-exports java.base/jdk.internal.misc=ALL-UNNAMED on the JVM" : ""), throwable.getCause());
    }

    private <T> Class<T> handleLinkageError(Throwable throwable, String name, ClassLoader loader) {
        if (LinkageError.class.isInstance(throwable) || LinkageError.class.isInstance(throwable.getCause())) {
            try {
                return Class.forName(name.replace('/', '.'), true, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isJava16OrMore() {
        String version = System.getProperty("java.version", "-1");
        int end = IntStream.of(version.indexOf(45), version.indexOf(46)).filter(i -> i > 0).min().orElseGet(version::length);
        try {
            return Integer.parseInt(version.substring(0, end)) >= 16;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method unsafeDefineClass() {
        Method value = this.unsafeDefineClass.get();
        if (value == null) {
            Unsafe unsafe = this;
            synchronized (unsafe) {
                Class<?> unsafeClass = this.internalUnsafe.getClass();
                value = AccessController.doPrivileged(() -> {
                    try {
                        return unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot get Unsafe.defineClass or equivalent", e);
                    }
                });
                this.unsafeDefineClass.compareAndSet(null, value);
            }
        }
        return value;
    }

    public <T> T unsafeNewInstance(Class<T> clazz) {
        try {
            if (this.unsafeAllocateInstance != null) {
                return (T)this.unsafeAllocateInstance.invoke(this.unsafe, clazz);
            }
            try {
                return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException() != null ? e.getTargetException() : e;
            throw new IllegalStateException("Failed to allocateInstance of Proxy class " + clazz.getName(), throwable);
        }
    }

    private Class<?> getUnsafeClass() {
        try {
            return AccessController.doPrivileged(() -> (Class)Stream.of(Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader()).flatMap(classloader -> Stream.of("sun.misc.Unsafe", "jdk.internal.misc.Unsafe").flatMap(name -> {
                try {
                    return Stream.of(classloader.loadClass((String)name));
                }
                catch (ClassNotFoundException e) {
                    return Stream.empty();
                }
            })).findFirst().orElseThrow(() -> new IllegalStateException("Cannot get Unsafe")));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get Unsafe class", e);
        }
    }
}

