/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openejb.jee.Connector10;
import org.apache.openejb.jee.Icon;
import org.apache.openejb.jee.License;
import org.apache.openejb.jee.LocalCollection;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.ResourceAdapter;
import org.apache.openejb.jee.Text;
import org.apache.openejb.jee.TextMap;

@XmlRootElement(name="connector")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="connectorType", propOrder={"moduleName", "descriptions", "displayNames", "icon", "vendorName", "eisType", "resourceAdapterVersion", "license", "resourceAdapter", "requiredWorkContext"})
public class Connector
implements NamedModule {
    @XmlElement(name="module-name")
    protected String moduleName;
    @XmlTransient
    protected TextMap description = new TextMap();
    @XmlTransient
    protected TextMap displayName = new TextMap();
    @XmlElement(name="icon", required=true)
    protected LocalCollection<Icon> icon = new LocalCollection();
    @XmlElement(name="vendor-name")
    protected String vendorName = "";
    @XmlElement(name="eis-type")
    protected String eisType = "";
    @XmlElement(name="resourceadapter-version")
    protected String resourceAdapterVersion = "";
    protected License license;
    @XmlElement(name="resourceadapter", required=true)
    protected ResourceAdapter resourceAdapter;
    @XmlElement(name="required-work-context")
    protected List<String> requiredWorkContext;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    protected String id;
    @XmlAttribute(required=true)
    protected String version;
    @XmlAttribute(name="metadata-complete")
    protected Boolean metadataComplete;

    public Connector() {
    }

    public Connector(String id) {
        this.id = id;
    }

    public static Connector newConnector(Connector10 source) {
        Connector connector = new Connector();
        connector.setDescriptions(source.getDescriptions());
        connector.setDisplayNames(source.getDisplayNames());
        connector.getIcons().addAll(source.getIcons());
        connector.setVendorName(source.getVendorName());
        connector.setEisType(source.getEisType());
        connector.setResourceAdapterVersion(source.getVersion());
        connector.setLicense(source.getLicense());
        connector.setId(source.getId());
        connector.setVersion(source.getSpecVersion());
        connector.setResourceAdapter(ResourceAdapter.newResourceAdapter(source.getResourceAdapter()));
        return connector;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @XmlElement(name="description", required=true)
    public Text[] getDescriptions() {
        return this.description.toArray();
    }

    public void setDescriptions(Text[] text) {
        this.description.set(text);
    }

    public String getDescription() {
        return this.description.get();
    }

    @XmlElement(name="display-name", required=true)
    public Text[] getDisplayNames() {
        return this.displayName.toArray();
    }

    public void setDisplayNames(Text[] text) {
        this.displayName.set(text);
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public Collection<Icon> getIcons() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon;
    }

    public Map<String, Icon> getIconMap() {
        if (this.icon == null) {
            this.icon = new LocalCollection();
        }
        return this.icon.toMap();
    }

    public Icon getIcon() {
        return this.icon.getLocal();
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String value) {
        this.vendorName = value;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String value) {
        this.eisType = value;
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    public void setResourceAdapterVersion(String value) {
        this.resourceAdapterVersion = value;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License value) {
        this.license = value;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.resourceAdapter = resourceAdapter;
    }

    public List<String> getRequiredWorkContext() {
        if (this.requiredWorkContext == null) {
            this.requiredWorkContext = new ArrayList<String>();
        }
        return this.requiredWorkContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String value) {
        this.id = value;
    }

    public String getVersion() {
        if (this.version == null) {
            return "1.6";
        }
        return this.version;
    }

    public void setVersion(String value) {
        this.version = value;
    }

    public Boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(Boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }
}

