/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;

public final class AttributeInfoUtil {
    private AttributeInfoUtil() {
    }

    public static Map<String, AttributeInfo> toMap(Collection<? extends AttributeInfo> attributes) {
        SortedMap<String, AttributeInfo> ret = CollectionUtil.newCaseInsensitiveMap();
        for (AttributeInfo attributeInfo : attributes) {
            ret.put(attributeInfo.getName(), attributeInfo);
        }
        return ret;
    }

    public static AttributeInfo find(String name, Set<AttributeInfo> attrs) {
        Assertions.nullCheck(name, "name");
        Set<AttributeInfo> set = CollectionUtil.nullAsEmpty(attrs);
        for (AttributeInfo attr : set) {
            if (!attr.is(name)) continue;
            return attr;
        }
        return null;
    }
}

