/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import lombok.Generated;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public abstract class BaseIdTokenGeneratorService<T extends OAuth20ConfigurationContext>
implements IdTokenGeneratorService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseIdTokenGeneratorService.class);
    private final ObjectProvider<T> configurationContextProvider;

    protected T getConfigurationContext() {
        return (T)((OAuth20ConfigurationContext)this.configurationContextProvider.getObject());
    }

    protected String encodeAndFinalizeToken(JwtClaims claims, OAuthRegisteredService registeredService, OAuth20AccessToken accessToken) throws Exception {
        LOGGER.debug("Received claims for the id token [{}] as [{}]", (Object)accessToken, (Object)claims);
        String idTokenResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getIdTokenSigningAndEncryptionService().encode(registeredService, claims);
        accessToken.setIdToken(idTokenResult);
        LOGGER.debug("Updating access token [{}] in ticket registry with ID token [{}]", (Object)accessToken.getId(), (Object)idTokenResult);
        ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().updateTicket((Ticket)accessToken);
        return idTokenResult;
    }

    @Generated
    protected BaseIdTokenGeneratorService(ObjectProvider<T> configurationContextProvider) {
        this.configurationContextProvider = configurationContextProvider;
    }

    @Generated
    public ObjectProvider<T> getConfigurationContextProvider() {
        return this.configurationContextProvider;
    }
}

