/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.List;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ResetableExporterFilter;

public class ExporterFilterContainer
implements ResetableExporterFilter {
    public static final String EXCEPTION_MESSAGE_KEY_NULL_FILTERS_LIST = "export.filter.null.filters.list";
    private final List<ExporterFilter> filters;

    public ExporterFilterContainer(List<ExporterFilter> filters) {
        if (filters == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NULL_FILTERS_LIST, (Object[])null);
        }
        this.filters = filters;
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        boolean export = true;
        for (ExporterFilter filter : this.filters) {
            if (filter.isToExport(element)) continue;
            export = false;
            break;
        }
        return export;
    }

    @Override
    public void reset() {
        for (ExporterFilter filter : this.filters) {
            if (!(filter instanceof ResetableExporterFilter)) continue;
            ((ResetableExporterFilter)filter).reset();
        }
    }
}

