/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.testing.mock.sling.NodeTypeDefinitionScanner;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderJsonDamTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());
    protected String path;

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.path = this.context.uniqueRoot().content() + "/dam";
        try {
            NodeTypeDefinitionScanner.get().register((Session)this.context.resourceResolver().adaptTo(Session.class), List.of("SLING-INF/nodetypes/app.cnd"), this.getResourceResolverType().getNodeTypeMode());
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to register namespaces.", ex);
        }
        this.context.load().json("/json-import-samples/dam.json", this.path + "/sample");
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testDamAssetMetadata() throws IOException {
        Resource assetMetadata = this.context.resourceResolver().getResource(this.path + "/sample/portraits/scott_reynolds.jpg/jcr:content/metadata");
        ValueMap props = ResourceUtil.getValueMap((Resource)assetMetadata);
        Assert.assertEquals((Object)"Canon\u0000", (Object)props.get("tiff:Make", String.class));
        Assert.assertEquals((Object)807L, (Object)props.get("tiff:ImageWidth", Long.class));
        Assert.assertEquals((Object)595, (Object)props.get("tiff:ImageLength", Integer.class));
        Assert.assertEquals((double)4.64385986328125, (double)((Double)props.get("dam:ApertureValue", Double.class)), (double)1.0E-11);
        Assert.assertArrayEquals((Object[])new String[]{"stockphotography:business/business_people", "properties:style/color", "properties:orientation/landscape"}, (Object[])((Object[])props.get("app:tags", String[].class)));
        Resource binaryMetadata = this.context.resourceResolver().getResource(this.path + "/sample/portraits/scott_reynolds.jpg/jcr:content/renditions/original/jcr:content");
        ValueMap binaryProps = ResourceUtil.getValueMap((Resource)binaryMetadata);
        InputStream is = (InputStream)binaryProps.get("jcr:data", InputStream.class);
        Assert.assertNotNull((Object)is);
        byte[] binaryData = IOUtils.toByteArray((InputStream)is);
        Assert.assertEquals((long)0L, (long)binaryData.length);
    }
}

