/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.filter.impl;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.filter.impl.Context;
import org.apache.sling.resource.filter.impl.Visitor;
import org.apache.sling.resource.filter.impl.node.Node;
import org.apache.sling.resource.filter.impl.predicates.Null;

public class ComparisonVisitor
implements Visitor<Function<Resource, Object>> {
    private Context context;

    public ComparisonVisitor(Context context) {
        this.context = context;
        context.setComparionVisitor(this);
    }

    @Override
    public Function<Resource, Object> visit(Node node) {
        switch (node.kind) {
            case 43: {
                return this.functionHandler(node);
            }
            case 23: {
                return resource -> new Null();
            }
            case 13: {
                return resource -> ComparisonVisitor.numericHandler(node.text);
            }
            case 10: {
                return resource -> OffsetDateTime.parse(node.text).toInstant();
            }
            case 11: {
                return resource -> LocalDateTime.parse(node.text).atOffset(ZoneOffset.UTC).toInstant();
            }
            case 12: {
                return resource -> LocalDate.parse(node.text).atStartOfDay(ZoneOffset.UTC).toInstant();
            }
            case 44: {
                return resource -> {
                    Object value = this.valueMapOf((Resource)resource).get((Object)node.text);
                    if (value instanceof Boolean) {
                        return value.toString();
                    }
                    if (value instanceof Calendar) {
                        return ((Calendar)value).toInstant();
                    }
                    return value;
                };
            }
            case 42: {
                return resource -> {
                    String argument = node.text;
                    Optional<Object> arg = this.context.getParameter(argument);
                    if (!arg.isPresent()) {
                        throw new NoSuchElementException(String.format("No value present for '%s'", argument));
                    }
                    return arg.get();
                };
            }
        }
        return resource -> node.text;
    }

    private ValueMap valueMapOf(Resource resource) {
        if (resource == null || ResourceUtil.isNonExistingResource((Resource)resource)) {
            return ValueMap.EMPTY;
        }
        return (ValueMap)resource.adaptTo(ValueMap.class);
    }

    private static Object dateHandler(Object[] arguments) {
        if (arguments.length == 0) {
            return Instant.now();
        }
        String dateString = arguments[0].toString();
        String formatString = null;
        if (arguments.length > 1) {
            formatString = arguments[1].toString();
            SimpleDateFormat dateFormat = new SimpleDateFormat(formatString);
            try {
                return Instant.ofEpochMilli(dateFormat.parse(dateString).getTime());
            }
            catch (ParseException e) {
                return null;
            }
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)dateString, OffsetDateTime::from).toInstant();
    }

    private Function<Resource, Object> functionHandler(Node node) {
        switch (node.text) {
            case "name": {
                return Resource::getName;
            }
            case "path": {
                return Resource::getPath;
            }
            case "date": {
                return resource -> {
                    Object[] arguments = node.visitChildren(this).stream().map(funct -> funct.apply(resource)).toArray();
                    return ComparisonVisitor.dateHandler(arguments);
                };
            }
        }
        Optional<BiFunction<Object[], Resource, Object>> temp = this.context.getFunction(node.text);
        if (temp.isPresent()) {
            List<Function<Resource, Object>> children2 = node.visitChildren(this);
            return resource -> {
                Object[] arguments = children2.stream().map(funct -> funct.apply(resource)).toArray();
                return ((BiFunction)temp.get()).apply(arguments, resource);
            };
        }
        return null;
    }

    private static Number numericHandler(String numberText) {
        Number numericValue = null;
        try {
            numericValue = Integer.valueOf(numberText);
        }
        catch (NumberFormatException nfe1) {
            try {
                numericValue = new BigDecimal(numberText);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return numericValue;
    }
}

