/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;

public class Enumerations {
    private Enumerations() {
    }

    public static <T> Enumeration<T> enumeration(Spliterator<? extends T> spliterator) {
        return new EnumerationSpliterator<Object, Object>(spliterator, t -> t, t -> true);
    }

    public static <T, R> Enumeration<R> enumeration(Spliterator<? extends T> spliterator, Function<? super T, ? extends R> mapper) {
        return new EnumerationSpliterator<T, Object>(spliterator, mapper, r -> true);
    }

    public static <T, R> Enumeration<R> enumeration(Spliterator<? extends T> spliterator, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
        return new EnumerationSpliterator<T, R>(spliterator, mapper, filter);
    }

    private static class EnumerationSpliterator<T, R>
    implements Enumeration<R> {
        private final Spliterator<? extends T> spliterator;
        private final Function<? super T, ? extends R> mapper;
        private final Predicate<? super R> filter;
        private boolean hasNext = false;
        private R next;

        EnumerationSpliterator(Spliterator<? extends T> spliterator, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
            this.spliterator = spliterator != null ? spliterator : Spliterators.emptySpliterator();
            this.mapper = Objects.requireNonNull(mapper);
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public boolean hasMoreElements() {
            do {
                if (!this.hasNext) continue;
                return true;
            } while (this.spliterator.tryAdvance(t -> {
                R r = this.mapper.apply(t);
                if (this.filter.test(r)) {
                    this.next = r;
                    this.hasNext = true;
                }
            }));
            return false;
        }

        @Override
        public R nextElement() {
            if (this.hasMoreElements()) {
                this.hasNext = false;
                return this.next;
            }
            throw new NoSuchElementException();
        }
    }
}

