/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.util.closeable.Builder;
import org.apache.sshd.common.util.closeable.IoBaseCloseable;

public abstract class AbstractCloseable
extends IoBaseCloseable {
    protected final Object lock = new Object();
    protected final AtomicReference<State> state = new AtomicReference<State>(State.Opened);
    protected final CloseFuture closeFuture;

    protected AbstractCloseable() {
        this("");
    }

    protected AbstractCloseable(String discriminator) {
        super(discriminator);
        this.closeFuture = new DefaultCloseFuture(discriminator, this.lock);
    }

    @Override
    public void addCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeFuture.addListener(listener);
    }

    @Override
    public void removeCloseFutureListener(SshFutureListener<CloseFuture> listener) {
        this.closeFuture.removeListener(listener);
    }

    @Override
    public CloseFuture close(boolean immediately) {
        if (immediately) {
            if (this.state.compareAndSet(State.Opened, State.Immediate) || this.state.compareAndSet(State.Graceful, State.Immediate)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("close({}) Closing immediately", (Object)this);
                }
                this.preClose();
                this.doCloseImmediately();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("close({})[Immediately] closed", (Object)this);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("close({})[Immediately] state already {}", (Object)this, (Object)this.state.get());
            }
        } else if (this.state.compareAndSet(State.Opened, State.Graceful)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("close({}) Closing gracefully", (Object)this);
            }
            this.preClose();
            CloseFuture grace = this.doCloseGracefully();
            if (grace != null) {
                grace.addListener(future -> {
                    if (this.state.compareAndSet(State.Graceful, State.Immediate)) {
                        this.doCloseImmediately();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("close({}][Graceful] - operationComplete() closed", (Object)this);
                        }
                    }
                });
            } else if (this.state.compareAndSet(State.Graceful, State.Immediate)) {
                this.doCloseImmediately();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("close({})[Graceful] closed", (Object)this);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("close({})[Graceful] state already {}", (Object)this, (Object)this.state.get());
        }
        return this.closeFuture;
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == State.Closed;
    }

    @Override
    public boolean isClosing() {
        return this.state.get() != State.Opened;
    }

    protected void preClose() {
    }

    protected CloseFuture doCloseGracefully() {
        return null;
    }

    protected void doCloseImmediately() {
        this.closeFuture.setClosed();
        this.state.set(State.Closed);
    }

    protected Builder builder() {
        return new Builder(this.lock);
    }

    public static enum State {
        Opened,
        Graceful,
        Immediate,
        Closed;

    }
}

