/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.framework;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class StateConfig
implements ManagedService {
    private static final String PID = StateConfig.class.getName();
    private static final String ATTRIBUTE_CHANGE_NOTIFICATION_ENABLED = "attributeChangeNotificationEnabled";
    private static final boolean DEFAULT_ATTRIBUTE_CHANGE_NOTIFICATION_ENABLED = true;
    private static final String SERVICE_CHANGE_NOTIFICATION_ENABLED = "serviceChangeNotificationEnabled";
    private static final boolean DEFAULT_SERVICE_CHANGE_NOTIFICATION_ENABLED = true;
    private static final String BUNDLE_CHANGE_NOTIFICATION_ENABLED = "bundleChangeNotificationEnabled";
    private static final boolean DEFAULT_BUNDLE_CHANGE_NOTIFICATION_ENABLED = true;
    private volatile boolean attributeChangeNotificationEnabled = true;
    private volatile boolean serviceChangeNotificationEnabled = true;
    private volatile boolean bundleChangeNotificationEnabled = true;

    void setAttributeChangeNotificationEnabled(boolean attributeChangeNotificationEnabled) {
        this.attributeChangeNotificationEnabled = attributeChangeNotificationEnabled;
    }

    void setServiceChangeNotificationEnabled(boolean serviceChangeNotificationEnabled) {
        this.serviceChangeNotificationEnabled = serviceChangeNotificationEnabled;
    }

    void setBundleChangeNotificationEnabled(boolean bundleChangeNotificationEnabled) {
        this.bundleChangeNotificationEnabled = bundleChangeNotificationEnabled;
    }

    public static StateConfig register(BundleContext context) throws IOException {
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put("service.pid", PID);
        StateConfig stateConfig = new StateConfig();
        context.registerService(ManagedService.class, (Object)stateConfig, serviceProps);
        return stateConfig;
    }

    public void updated(Dictionary<String, ?> dictionary) throws ConfigurationException {
        this.attributeChangeNotificationEnabled = StateConfig.getBoolean(dictionary, ATTRIBUTE_CHANGE_NOTIFICATION_ENABLED, true);
        this.serviceChangeNotificationEnabled = StateConfig.getBoolean(dictionary, SERVICE_CHANGE_NOTIFICATION_ENABLED, true);
        this.bundleChangeNotificationEnabled = StateConfig.getBoolean(dictionary, BUNDLE_CHANGE_NOTIFICATION_ENABLED, true);
    }

    public boolean isAttributeChangeNotificationEnabled() {
        return this.attributeChangeNotificationEnabled;
    }

    public boolean isServiceChangeNotificationEnabled() {
        return this.serviceChangeNotificationEnabled;
    }

    public boolean isBundleChangeNotificationEnabled() {
        return this.bundleChangeNotificationEnabled;
    }

    private static boolean getBoolean(Dictionary<String, ?> dictionary, String propertyName, boolean defaultValue) {
        Object object;
        Object object2 = object = dictionary != null ? (Object)dictionary.get(propertyName) : null;
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString();
        return !string.isEmpty() ? Boolean.parseBoolean(string) : defaultValue;
    }
}

