/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.bulkloader;

import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.tdb1.store.bulkloader.BuilderSecondaryIndexes;
import org.apache.jena.tdb1.store.bulkloader.LoadMonitor;
import org.apache.jena.tdb1.store.bulkloader.LoaderNodeTupleTable;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;

public class BuilderSecondaryIndexesInterleaved
implements BuilderSecondaryIndexes {
    private LoadMonitor monitor;

    public BuilderSecondaryIndexesInterleaved(LoadMonitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void createSecondaryIndexes(TupleIndex primaryIndex, TupleIndex[] secondaryIndexes) {
        Timer timer = new Timer();
        timer.startTimer();
        long time1 = timer.readTimer();
        LoaderNodeTupleTable.copyIndex(primaryIndex.all(), secondaryIndexes, "All", this.monitor);
        long time2 = timer.readTimer();
        this.monitor.print("Time for all indexes: %.2fs\n", (double)(time2 - time1) / 1000.0);
    }
}

