/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.javax.MultipartUtil;
import org.apache.james.mime4j.field.Fields;
import org.apache.james.util.StreamUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasMimeTypeAnySubPart
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasMimeTypeAnySubPart.class);
    private static final String MULTIPART_MIME_TYPE = "multipart/*";
    private Set<String> acceptedContentTypes;

    public void init() throws MessagingException {
        this.acceptedContentTypes = ImmutableSet.copyOf((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)this.getCondition()));
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return this.detectMatchingMimeTypes((Part)mail.getMessage()).findAny().map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }

    private boolean isMultipart(Part part) throws MailetException {
        try {
            return part.isMimeType(MULTIPART_MIME_TYPE);
        }
        catch (MessagingException e) {
            throw new MailetException("Could not retrieve contenttype of MimePart.", (Exception)((Object)e));
        }
    }

    private Stream<String> detectMatchingMimeTypes(Part part) throws MailetException {
        try {
            if (this.isMultipart(part)) {
                Multipart multipart = (Multipart)part.getContent();
                return Stream.concat(MultipartUtil.retrieveBodyParts((Multipart)multipart).stream().flatMap(Throwing.function(this::detectMatchingMimeTypes).sneakyThrow()), this.detectMatchingMimeTypesNoRecursion(part));
            }
            return this.detectMatchingMimeTypesNoRecursion(part);
        }
        catch (MessagingException | IOException e) {
            throw new MailetException("Could not retrieve contenttype of MimePart.", (Exception)e);
        }
    }

    private Stream<String> detectMatchingMimeTypesNoRecursion(Part part) throws MessagingException {
        return StreamUtils.ofNullable((Object[])part.getHeader("Content-Type")).flatMap(this::getMimeType).filter(this.acceptedContentTypes::contains);
    }

    private Stream<String> getMimeType(String rawValue) {
        try {
            return Stream.of(Fields.contentType((String)rawValue).getMimeType());
        }
        catch (Exception e) {
            LOGGER.warn("Error while parsing message's mimeType {}", (Object)rawValue, (Object)e);
            return Stream.empty();
        }
    }
}

