/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.generic;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.ApiClient;
import org.opensearch.client.opensearch.generic.Body;
import org.opensearch.client.opensearch.generic.GenericResponse;
import org.opensearch.client.opensearch.generic.OpenSearchClientException;
import org.opensearch.client.opensearch.generic.Request;
import org.opensearch.client.opensearch.generic.Response;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportOptions;

public class OpenSearchGenericClient
extends ApiClient<OpenSearchTransport, OpenSearchGenericClient> {
    private final ClientOptions clientOptions;

    public OpenSearchGenericClient(OpenSearchTransport transport) {
        this(transport, null, ClientOptions.DEFAULT);
    }

    public OpenSearchGenericClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions) {
        this(transport, transportOptions, ClientOptions.DEFAULT);
    }

    public OpenSearchGenericClient(OpenSearchTransport transport, @Nullable TransportOptions transportOptions, ClientOptions clientOptions) {
        super(transport, transportOptions);
        this.clientOptions = clientOptions;
    }

    public OpenSearchGenericClient withClientOptions(ClientOptions clientOptions) {
        return new OpenSearchGenericClient((OpenSearchTransport)this.transport, this.transportOptions, clientOptions);
    }

    @Override
    public OpenSearchGenericClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new OpenSearchGenericClient((OpenSearchTransport)this.transport, transportOptions, this.clientOptions);
    }

    public Response execute(Request request) throws IOException {
        return ((OpenSearchTransport)this.transport).performRequest(request, new GenericEndpoint(request, this.clientOptions.error), this.transportOptions);
    }

    public CompletableFuture<Response> executeAsync(Request request) {
        return ((OpenSearchTransport)this.transport).performRequestAsync(request, new GenericEndpoint(request, this.clientOptions.error), this.transportOptions);
    }

    private static final class GenericEndpoint
    implements org.opensearch.client.transport.GenericEndpoint<Request, Response> {
        private final Request request;
        private final Predicate<Integer> error;

        public GenericEndpoint(Request request, Predicate<Integer> error) {
            this.request = request;
            this.error = error;
        }

        @Override
        public String method(Request request) {
            return request.getMethod();
        }

        @Override
        public String requestUrl(Request request) {
            return request.getEndpoint();
        }

        @Override
        public boolean hasRequestBody() {
            return this.request.getBody().isPresent();
        }

        @Override
        public Map<String, String> queryParameters(Request request) {
            return request.getParameters();
        }

        @Override
        public Map<String, String> headers(Request request) {
            return request.getHeaders().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public GenericResponse responseDeserializer(String uri, String method, String protocol, int status, String reason, List<Map.Entry<String, String>> headers, @Nullable String contentType, @Nullable InputStream body) {
            try (Body b = Body.from(body, contentType);){
                if (b != null) {
                    GenericResponse genericResponse2 = new GenericResponse(uri, protocol, method, status, reason, headers, Body.from(b.bodyAsBytes(), b.contentType()));
                    return genericResponse2;
                }
                GenericResponse genericResponse = new GenericResponse(uri, protocol, method, status, reason, headers);
                return genericResponse;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public boolean isError(int statusCode) {
            return this.error.test(statusCode);
        }

        @Override
        public <T extends RuntimeException> T exceptionConverter(int statusCode, @Nullable Response error) {
            throw new OpenSearchClientException(error);
        }
    }

    public static final class ClientOptions {
        private static final ClientOptions DEFAULT = new ClientOptions();
        private final Predicate<Integer> error;

        private ClientOptions() {
            this(statusCode -> false);
        }

        private ClientOptions(Predicate<Integer> error) {
            this.error = error;
        }

        public static ClientOptions throwOnHttpErrors() {
            return new ClientOptions(statusCode -> statusCode >= 400);
        }
    }
}

