/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.IndexPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutIndexPolicyResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutIndexPolicyResponse> {
    private static final SdkField<IndexPolicy> INDEX_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("indexPolicy").getter(PutIndexPolicyResponse.getter(PutIndexPolicyResponse::indexPolicy)).setter(PutIndexPolicyResponse.setter(Builder::indexPolicy)).constructor(IndexPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutIndexPolicyResponse.memberNameToFieldInitializer();
    private final IndexPolicy indexPolicy;

    private PutIndexPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.indexPolicy = builder.indexPolicy;
    }

    public final IndexPolicy indexPolicy() {
        return this.indexPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIndexPolicyResponse)) {
            return false;
        }
        PutIndexPolicyResponse other = (PutIndexPolicyResponse)((Object)obj);
        return Objects.equals(this.indexPolicy(), other.indexPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutIndexPolicyResponse").add("IndexPolicy", (Object)this.indexPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "indexPolicy": {
                return Optional.ofNullable(clazz.cast(this.indexPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<IndexPolicy>> map = new HashMap<String, SdkField<IndexPolicy>>();
        map.put("indexPolicy", INDEX_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutIndexPolicyResponse, T> g) {
        return obj -> g.apply((PutIndexPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private IndexPolicy indexPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIndexPolicyResponse model) {
            super(model);
            this.indexPolicy(model.indexPolicy);
        }

        public final IndexPolicy.Builder getIndexPolicy() {
            return this.indexPolicy != null ? this.indexPolicy.toBuilder() : null;
        }

        public final void setIndexPolicy(IndexPolicy.BuilderImpl indexPolicy) {
            this.indexPolicy = indexPolicy != null ? indexPolicy.build() : null;
        }

        @Override
        public final Builder indexPolicy(IndexPolicy indexPolicy) {
            this.indexPolicy = indexPolicy;
            return this;
        }

        @Override
        public PutIndexPolicyResponse build() {
            return new PutIndexPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutIndexPolicyResponse> {
        public Builder indexPolicy(IndexPolicy var1);

        default public Builder indexPolicy(Consumer<IndexPolicy.Builder> indexPolicy) {
            return this.indexPolicy((IndexPolicy)((IndexPolicy.Builder)IndexPolicy.builder().applyMutation(indexPolicy)).build());
        }
    }
}

