/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.apiserver.http.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Base64;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.apiserver.http.IHTTPRequestHandler;
import org.apache.bifromq.apiserver.http.handler.utils.JSONUtils;
import org.apache.bifromq.basecluster.IAgentHost;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;

@Path(value="/cluster")
final class GetClusterHandler
implements IHTTPRequestHandler {
    private final IAgentHost agentHost;

    GetClusterHandler(IAgentHost agentHost) {
        this.agentHost = agentHost;
    }

    @Override
    @GET
    @Operation(summary="Get cluster membership known from current node")
    @Parameters(value={@Parameter(name="req_id", in=ParameterIn.HEADER, description="optional caller provided request id", schema=@Schema(implementation=Long.class))})
    @RequestBody(required=false)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Success", content={@Content(mediaType="application/json")})})
    public CompletableFuture<FullHttpResponse> handle(@Parameter(hidden=true) long reqId, @Parameter(hidden=true) FullHttpRequest req) {
        return this.agentHost.membership().first(Set.of(this.agentHost.local())).toCompletionStage().toCompletableFuture().thenApply(nodes -> {
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(req.protocolVersion(), HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])this.toJSON((Set<HostEndpoint>)nodes).getBytes()));
            resp.headers().set("Content-Type", (Object)"application/json");
            return resp;
        });
    }

    private String toJSON(Set<HostEndpoint> nodes) {
        ObjectMapper mapper = JSONUtils.MAPPER;
        ObjectNode rootObject = mapper.createObjectNode();
        rootObject.put("env", this.agentHost.env());
        ArrayNode arrayNode = mapper.createArrayNode();
        rootObject.set("nodes", (JsonNode)arrayNode);
        rootObject.put("local", Base64.getEncoder().encodeToString(this.agentHost.local().getId().toByteArray()));
        for (HostEndpoint node : nodes) {
            ObjectNode nodeObject = mapper.createObjectNode();
            nodeObject.put("id", Base64.getEncoder().encodeToString(node.getId().toByteArray()));
            nodeObject.put("address", node.getAddress());
            nodeObject.put("port", node.getPort());
            nodeObject.put("pid", node.getPid());
            arrayNode.add((JsonNode)nodeObject);
        }
        return rootObject.toString();
    }
}

