/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.client.loadbalancer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class LBUtils {
    LBUtils() {
    }

    static <T> List<T> toWeightedRRSequence(Map<T, Integer> weightedValues) {
        ArrayList tuples = Lists.newArrayListWithCapacity((int)weightedValues.size());
        weightedValues.forEach((server, weight) -> tuples.add(new WeightedValue<Object>((Integer)weight, server)));
        ArrayList sequence = new ArrayList();
        int i = -1;
        int n = tuples.size();
        int currentW = 0;
        List<Integer> weights = tuples.stream().map(tuple -> tuple.weight).collect(Collectors.toList());
        if (!weights.isEmpty()) {
            int maxW = (Integer)Collections.max(weights);
            int gcdW = LBUtils.getGCD(weights);
            while (true) {
                if ((i = (i + 1) % n) == 0) {
                    if ((currentW -= gcdW) < 0) {
                        currentW = maxW;
                    }
                    if (currentW == 0) break;
                }
                if (weights.get(i) < currentW) continue;
                sequence.add(((WeightedValue)tuples.get((int)i)).val);
            }
        }
        return sequence;
    }

    private static int gcd(int a, int b) {
        if (a == 0) {
            return b;
        }
        return LBUtils.gcd(b % a, a);
    }

    private static int getGCD(List<Integer> ints) {
        int n = ints.size();
        int result = ints.get(0);
        for (int i = 1; i < n; ++i) {
            result = LBUtils.gcd(ints.get(i), result);
        }
        return result;
    }

    private record WeightedValue<X>(Integer weight, X val) {
    }
}

