/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.scheduler;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.BatchMutationCall;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.baserpc.client.exception.ServerNotFoundException;
import org.apache.bifromq.basescheduler.ICallTask;
import org.apache.bifromq.dist.rpc.proto.BatchUnmatchReply;
import org.apache.bifromq.dist.rpc.proto.BatchUnmatchRequest;
import org.apache.bifromq.dist.rpc.proto.DistServiceRWCoProcInput;
import org.apache.bifromq.dist.rpc.proto.MatchRoute;
import org.apache.bifromq.dist.rpc.proto.UnmatchReply;
import org.apache.bifromq.dist.rpc.proto.UnmatchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BatchUnmatchCall
extends BatchMutationCall<UnmatchRequest, UnmatchReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchUnmatchCall.class);

    BatchUnmatchCall(IMutationPipeline pipeline, MutationCallBatcherKey batcherKey) {
        super(pipeline, batcherKey);
    }

    protected RWCoProcInput makeBatch(Iterable<ICallTask<UnmatchRequest, UnmatchReply, MutationCallBatcherKey>> callTasks) {
        BatchUnmatchRequest.Builder reqBuilder = BatchUnmatchRequest.newBuilder();
        HashMap<String, BatchUnmatchRequest.TenantBatch.Builder> builders = new HashMap<String, BatchUnmatchRequest.TenantBatch.Builder>();
        for (UnmatchRequest unmatchReq : Iterables.transform(callTasks, ICallTask::call)) {
            builders.computeIfAbsent(unmatchReq.getTenantId(), k -> BatchUnmatchRequest.TenantBatch.newBuilder()).addRoute(MatchRoute.newBuilder().setMatcher(unmatchReq.getMatcher()).setReceiverId(unmatchReq.getReceiverId()).setDelivererKey(unmatchReq.getDelivererKey()).setBrokerId(unmatchReq.getBrokerId()).setIncarnation(unmatchReq.getIncarnation()).build());
        }
        builders.forEach((t, builder) -> reqBuilder.putRequests(t, builder.build()));
        long reqId = System.nanoTime();
        return RWCoProcInput.newBuilder().setDistService(DistServiceRWCoProcInput.newBuilder().setBatchUnmatch(reqBuilder.setReqId(reqId).build()).build()).build();
    }

    protected void handleException(ICallTask<UnmatchRequest, UnmatchReply, MutationCallBatcherKey> callTask, Throwable e) {
        if (e instanceof ServerNotFoundException) {
            callTask.resultPromise().complete(UnmatchReply.newBuilder().setReqId(((UnmatchRequest)callTask.call()).getReqId()).setResult(UnmatchReply.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof BadVersionException) {
            callTask.resultPromise().complete(UnmatchReply.newBuilder().setReqId(((UnmatchRequest)callTask.call()).getReqId()).setResult(UnmatchReply.Result.TRY_LATER).build());
            return;
        }
        if (e instanceof TryLaterException) {
            callTask.resultPromise().complete(UnmatchReply.newBuilder().setReqId(((UnmatchRequest)callTask.call()).getReqId()).setResult(UnmatchReply.Result.TRY_LATER).build());
            return;
        }
        callTask.resultPromise().completeExceptionally(e);
    }

    protected void handleOutput(Queue<ICallTask<UnmatchRequest, UnmatchReply, MutationCallBatcherKey>> batchedTasks, RWCoProcOutput output) {
        ICallTask<UnmatchRequest, UnmatchReply, MutationCallBatcherKey> callTask;
        BatchUnmatchReply reply = output.getDistService().getBatchUnmatch();
        HashMap<String, List> tasksByTenant = new HashMap<String, List>();
        while ((callTask = batchedTasks.poll()) != null) {
            tasksByTenant.computeIfAbsent(((UnmatchRequest)callTask.call()).getTenantId(), k -> new ArrayList()).add(callTask);
        }
        for (String tenantId : tasksByTenant.keySet()) {
            List tasks = (List)tasksByTenant.get(tenantId);
            List codes = ((BatchUnmatchReply.TenantBatch)reply.getResultsMap().get(tenantId)).getCodeList();
            assert (tasks.size() == codes.size());
            for (int i = 0; i < tasks.size(); ++i) {
                UnmatchReply.Result unmatchResult = switch ((BatchUnmatchReply.TenantBatch.Code)codes.get(i)) {
                    case BatchUnmatchReply.TenantBatch.Code.OK -> UnmatchReply.Result.OK;
                    case BatchUnmatchReply.TenantBatch.Code.NOT_EXISTED -> UnmatchReply.Result.NOT_EXISTED;
                    default -> {
                        log.error("Unexpected unmatch result: {}", codes.get(i));
                        yield UnmatchReply.Result.ERROR;
                    }
                };
                ((ICallTask)tasks.get(i)).resultPromise().complete(UnmatchReply.newBuilder().setReqId(((UnmatchRequest)((ICallTask)tasks.get(i)).call()).getReqId()).setResult(unmatchResult).build());
            }
        }
    }
}

