/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.hlc;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.internal.hlc.ClockUpdateListener;
import org.apache.ignite3.internal.hlc.HybridClock;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.manager.ComponentContext;
import org.apache.ignite3.internal.manager.IgniteComponent;
import org.apache.ignite3.internal.thread.IgniteThreadFactory;
import org.apache.ignite3.internal.thread.ThreadOperation;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.PendingComparableValuesTracker;

public class ClockWaiter
implements IgniteComponent {
    private final HybridClock clock;
    private final AtomicBoolean stopGuard = new AtomicBoolean(false);
    private final PendingComparableValuesTracker<Long, Void> nowTracker = new PendingComparableValuesTracker(HybridTimestamp.MIN_VALUE.longValue());
    private final ClockUpdateListener updateListener = this::onUpdate;
    private final Runnable triggerClockUpdate = this::triggerTrackerUpdate;
    private final ScheduledExecutorService scheduler;
    private final ExecutorService futureExecutor;

    public ClockWaiter(String nodeName, HybridClock clock, ScheduledExecutorService scheduler) {
        this.clock = clock;
        this.scheduler = scheduler;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), IgniteThreadFactory.create(nodeName, "clock-waiter-future-executor", Loggers.forClass(ClockWaiter.class), new ThreadOperation[0]));
        executor.allowCoreThreadTimeOut(true);
        this.futureExecutor = executor;
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.clock.addUpdateListener(this.updateListener);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.clock.removeUpdateListener(this.updateListener);
        this.nowTracker.close(new NodeStoppingException());
        IgniteUtils.shutdownAndAwaitTermination(this.futureExecutor, 10L, TimeUnit.SECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    private void onUpdate(long newTs) {
        this.nowTracker.update(newTs, null);
    }

    public CompletableFuture<Void> waitFor(HybridTimestamp targetTimestamp) {
        return this.doWaitFor(targetTimestamp);
    }

    private CompletableFuture<Void> doWaitFor(HybridTimestamp targetTimestamp) {
        HybridTimestamp now = this.clock.now();
        if (targetTimestamp.compareTo(now) <= 0) {
            return CompletableFutures.nullCompletedFuture();
        }
        CompletableFuture<Void> future = this.nowTracker.waitFor(targetTimestamp.longValue());
        long millisToWait = targetTimestamp.getPhysical() - now.getPhysical() + 1L;
        ScheduledFuture<?> scheduledFuture = this.scheduler.schedule(this.triggerClockUpdate, millisToWait, TimeUnit.MILLISECONDS);
        return future.thenRunAsync(() -> scheduledFuture.cancel(true), this.futureExecutor);
    }

    private void triggerTrackerUpdate() {
        CompletableFuture.runAsync(() -> this.onUpdate(this.clock.nowLong()), this.futureExecutor);
    }
}

