/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.ignite.internal.util.GridBoundedLinkedHashMap;
import org.apache.ignite.internal.util.GridSerializableSet;

public class GridBoundedLinkedHashSet<E>
extends GridSerializableSet<E>
implements Cloneable {
    private static final long serialVersionUID = 0L;
    private static final Object FAKE = Boolean.TRUE;
    private transient HashMap<E, Object> map;

    public GridBoundedLinkedHashSet(int maxCap) {
        assert (maxCap > 0);
        this.map = new GridBoundedLinkedHashMap<E, Object>(maxCap);
    }

    public GridBoundedLinkedHashSet(Collection<? extends E> c, int maxCap) {
        assert (maxCap > 0);
        this.map = new GridBoundedLinkedHashMap<E, Object>(Math.max((int)((float)c.size() / 0.75f) + 1, 16), maxCap);
        this.addAll(c);
    }

    public GridBoundedLinkedHashSet(int initCap, int maxCap, float loadFactor) {
        assert (maxCap > 0);
        this.map = new GridBoundedLinkedHashMap<E, Object>(initCap, maxCap, loadFactor);
    }

    public GridBoundedLinkedHashSet(int initCap, int maxCap, float loadFactor, boolean accessOrder) {
        assert (maxCap > 0);
        this.map = new GridBoundedLinkedHashMap<E, Object>(initCap, maxCap, loadFactor, accessOrder);
    }

    public GridBoundedLinkedHashSet(int initCap, int maxCap) {
        assert (maxCap > 0);
        this.map = new GridBoundedLinkedHashMap<E, Object>(initCap, maxCap);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.map.put(o, FAKE) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == FAKE;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        GridBoundedLinkedHashSet newSet = (GridBoundedLinkedHashSet)super.clone();
        newSet.map = (HashMap)this.map.clone();
        return newSet;
    }
}

