/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.stat.view;

import java.sql.Timestamp;
import org.apache.ignite.internal.managers.systemview.walker.Filtrable;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.stat.ObjectStatisticsImpl;
import org.apache.ignite.internal.processors.query.stat.StatisticsKey;

public class StatisticsColumnGlobalDataView {
    private final StatisticsKey key;
    private final ObjectStatisticsImpl statistics;
    private final String column;

    public StatisticsColumnGlobalDataView(StatisticsKey key, String column, ObjectStatisticsImpl statistics) {
        this.key = key;
        this.column = column;
        this.statistics = statistics;
    }

    @Order
    @Filtrable
    public String schema() {
        return this.key.schema();
    }

    @Order(value=1)
    @Filtrable
    public String type() {
        return "TABLE";
    }

    @Order(value=2)
    @Filtrable
    public String name() {
        return this.key.obj();
    }

    @Order(value=3)
    @Filtrable
    public String column() {
        return this.column;
    }

    @Order(value=4)
    public long rowsCount() {
        return this.statistics.rowCount();
    }

    @Order(value=5)
    public long distinct() {
        return this.statistics.columnStatistics(this.column).distinct();
    }

    @Order(value=6)
    public long nulls() {
        return this.statistics.columnStatistics(this.column).nulls();
    }

    @Order(value=7)
    public long total() {
        return this.statistics.columnStatistics(this.column).total();
    }

    @Order(value=8)
    public int size() {
        return this.statistics.columnStatistics(this.column).size();
    }

    @Order(value=9)
    public long version() {
        return this.statistics.columnStatistics(this.column).version();
    }

    @Order(value=10)
    public Timestamp lastUpdateTime() {
        return new Timestamp(this.statistics.columnStatistics(this.column).createdAt());
    }
}

