/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.metastorage.persistence;

import java.io.Serializable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageClusterNodeData;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageHistoryItem;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageKeyValuePair;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageUtil;
import org.apache.ignite.internal.processors.metastorage.persistence.DistributedMetaStorageVersion;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.jetbrains.annotations.Nullable;

class InMemoryCachedDistributedMetaStorageBridge {
    private final JdkMarshaller marshaller;
    private final SortedMap<String, byte[]> cache = new TreeMap<String, byte[]>();

    public InMemoryCachedDistributedMetaStorageBridge(JdkMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Serializable read(String globalKey) throws IgniteCheckedException {
        return DistributedMetaStorageUtil.unmarshal(this.marshaller, this.readMarshalled(globalKey));
    }

    public byte[] readMarshalled(String globalKey) {
        return (byte[])this.cache.get(globalKey);
    }

    public void iterate(String globalKeyPrefix, BiConsumer<String, ? super Serializable> cb) throws IgniteCheckedException {
        for (Map.Entry<String, byte[]> entry : this.cache.tailMap(globalKeyPrefix).entrySet()) {
            if (!entry.getKey().startsWith(globalKeyPrefix)) break;
            cb.accept(entry.getKey(), DistributedMetaStorageUtil.unmarshal(this.marshaller, entry.getValue()));
        }
    }

    public void write(String globalKey, @Nullable byte[] valBytes) {
        if (valBytes == null) {
            this.cache.remove(globalKey);
        } else {
            this.cache.put(globalKey, valBytes);
        }
    }

    public DistributedMetaStorageKeyValuePair[] localFullData() {
        return (DistributedMetaStorageKeyValuePair[])this.cache.entrySet().stream().map(entry -> new DistributedMetaStorageKeyValuePair((String)entry.getKey(), (byte[])entry.getValue())).toArray(DistributedMetaStorageKeyValuePair[]::new);
    }

    public void writeFullNodeData(DistributedMetaStorageClusterNodeData fullNodeData) {
        assert (fullNodeData.fullData != null);
        this.cache.clear();
        for (DistributedMetaStorageKeyValuePair item : fullNodeData.fullData) {
            this.cache.put(item.key, item.valBytes);
        }
    }

    public DistributedMetaStorageVersion readInitialData(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        DistributedMetaStorageHistoryItem lastHistItem;
        if (metastorage.readRaw(DistributedMetaStorageUtil.cleanupGuardKey()) != null) {
            return DistributedMetaStorageVersion.INITIAL_VERSION;
        }
        DistributedMetaStorageVersion storedVer = (DistributedMetaStorageVersion)metastorage.read(DistributedMetaStorageUtil.versionKey());
        if (storedVer == null) {
            return DistributedMetaStorageVersion.INITIAL_VERSION;
        }
        DistributedMetaStorageVersion ver = storedVer;
        DistributedMetaStorageHistoryItem histItem = (DistributedMetaStorageHistoryItem)metastorage.read(DistributedMetaStorageUtil.historyItemKey(storedVer.id() + 1L));
        if (histItem != null) {
            lastHistItem = histItem;
            ver = storedVer.nextVersion(histItem);
        } else {
            lastHistItem = (DistributedMetaStorageHistoryItem)metastorage.read(DistributedMetaStorageUtil.historyItemKey(storedVer.id()));
        }
        metastorage.iterate(DistributedMetaStorageUtil.localKeyPrefix(), (key, val) -> this.cache.put(DistributedMetaStorageUtil.globalKey(key), (byte[])val), false);
        if (lastHistItem != null) {
            int len = lastHistItem.keys().length;
            for (int i = 0; i < len; ++i) {
                String key2 = lastHistItem.keys()[i];
                byte[] valBytes = lastHistItem.valuesBytesArray()[i];
                if (valBytes == null) {
                    this.cache.remove(key2);
                    continue;
                }
                this.cache.put(key2, valBytes);
            }
        }
        return ver;
    }
}

